/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESStructureValidator;

public class XAdESStructureValidatorFactory {
    private static XAdESStructureValidatorFactory singleton;

    protected XAdESStructureValidatorFactory() {
    }

    public static XAdESStructureValidatorFactory getInstance() {
        if (singleton == null) {
            singleton = new XAdESStructureValidatorFactory();
        }
        return singleton;
    }

    public XAdESStructureValidator fromXAdESSignature(XAdESSignature signature) {
        this.assertXAdESStructureValidatorLoaded();
        return new XAdESStructureValidator(signature.getSignatureElement(), signature.getXAdESPaths());
    }

    protected void assertXAdESStructureValidatorLoaded() {
        try {
            Class.forName("eu.europa.esig.dss.xades.validation.XAdESStructureValidator");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new ExceptionInInitializerError("No implementation found for XSD Utils in classpath, please include 'dss-validation' module for structure validation.");
        }
    }
}

