/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.CommitmentType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.enumerations.ObjectIdentifier;
import eu.europa.esig.dss.enumerations.ObjectIdentifierQualifier;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.CommitmentQualifier;
import eu.europa.esig.dss.model.CommonCommitmentType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SignerLocation;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.UserNotice;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.x509.tsp.TimestampInclude;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSObject;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.dataobject.DSSDataObjectFormat;
import eu.europa.esig.dss.xades.dataobject.DataObjectFormatBuilder;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Attribute;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.ReferenceBuilder;
import eu.europa.esig.dss.xades.reference.ReferenceIdProvider;
import eu.europa.esig.dss.xades.reference.ReferenceProcessor;
import eu.europa.esig.dss.xades.reference.ReferenceVerifier;
import eu.europa.esig.dss.xades.signature.DetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopingSignatureBuilder;
import eu.europa.esig.dss.xades.signature.InternallyDetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import eu.europa.esig.dss.xades.signature.XmlPolicyWithTransforms;
import eu.europa.esig.dss.xades.validation.XAdESAttributeIdentifier;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.dss.xml.utils.XMLCanonicalizer;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XAdESSignatureBuilder
extends XAdESBuilder
implements SignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureBuilder.class);
    protected boolean built = false;
    protected List<DSSDocument> documents;
    protected String keyInfoCanonicalizationMethod;
    protected String signedInfoCanonicalizationMethod;
    protected String signedPropertiesCanonicalizationMethod;
    protected final String deterministicId;
    protected Element signatureDom;
    protected Element keyInfoDom;
    protected Element signedInfoDom;
    protected Element signatureValueDom;
    protected Element qualifyingPropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedSignaturePropertiesDom;
    protected Element signedDataObjectPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;
    protected static final String REFERENCE_PREFIX = "r-";
    protected static final String KEYINFO_PREFIX = "keyInfo-";
    protected static final String VALUE_PREFIX = "value-";
    protected static final String XADES_PREFIX = "xades-";

    public static XAdESSignatureBuilder getSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        return XAdESSignatureBuilder.getSignatureBuilder(params, Collections.singletonList(document), certificateVerifier);
    }

    public static XAdESSignatureBuilder getSignatureBuilder(XAdESSignatureParameters params, List<DSSDocument> documents, CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(params.getSignaturePackaging(), "Cannot create a SignatureBuilder. SignaturePackaging shall be defined!");
        switch (params.getSignaturePackaging()) {
            case ENVELOPED: {
                return new EnvelopedSignatureBuilder(params, documents, certificateVerifier);
            }
            case ENVELOPING: {
                return new EnvelopingSignatureBuilder(params, documents, certificateVerifier);
            }
            case DETACHED: {
                return new DetachedSignatureBuilder(params, documents, certificateVerifier);
            }
            case INTERNALLY_DETACHED: {
                return new InternallyDetachedSignatureBuilder(params, documents, certificateVerifier);
            }
        }
        throw new DSSException("Unsupported packaging " + (Object)((Object)params.getSignaturePackaging()));
    }

    protected XAdESSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        this(params, Collections.singletonList(document), certificateVerifier);
    }

    protected XAdESSignatureBuilder(XAdESSignatureParameters params, List<DSSDocument> documents, CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.params = params;
        this.documents = documents;
        this.deterministicId = params.getDeterministicId();
        this.setCanonicalizationMethods(params);
    }

    private void setCanonicalizationMethods(XAdESSignatureParameters params) {
        this.keyInfoCanonicalizationMethod = params.getKeyInfoCanonicalizationMethod();
        this.signedInfoCanonicalizationMethod = params.getSignedInfoCanonicalizationMethod();
        this.signedPropertiesCanonicalizationMethod = params.getSignedPropertiesCanonicalizationMethod();
    }

    public byte[] build() throws DSSException {
        this.assertSignaturePossible();
        this.ensureConfigurationValidity();
        this.xadesPath = this.getCurrentXAdESPath();
        this.initRootDocumentDom();
        this.incorporateFiles();
        this.incorporateSignatureDom();
        this.incorporateSignedInfo();
        this.incorporateSignatureValue();
        this.incorporateKeyInfo();
        this.incorporateObjects();
        if (Utils.isArrayEmpty(this.params.getSignedData())) {
            this.incorporateReferences();
            this.incorporateReferenceSignedProperties();
            this.incorporateReferenceKeyInfo();
        }
        byte[] canonicalizedSignedInfo = XMLCanonicalizer.createInstance(this.signedInfoCanonicalizationMethod).canonicalize(this.getNodeToCanonicalize(this.signedInfoDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalized SignedInfo         --> {}", (Object)new String(canonicalizedSignedInfo));
            byte[] digest = DSSUtils.digest(DigestAlgorithm.SHA256, canonicalizedSignedInfo);
            LOG.trace("Canonicalized SignedInfo SHA256  --> {}", (Object)Utils.toBase64(digest));
        }
        this.built = true;
        return canonicalizedSignedInfo;
    }

    protected void assertSignaturePossible() {
        if (Utils.collectionSize(this.documents) == 0) {
            throw new IllegalArgumentException("No documents have been provided to the signature creation!");
        }
    }

    private void ensureConfigurationValidity() {
        this.checkSignaturePackagingValidity();
        List<DSSReference> references = this.params.getReferences();
        if (Utils.isCollectionEmpty(references)) {
            ReferenceBuilder referenceBuilder = this.initReferenceBuilder();
            List<DSSReference> defaultReferences = referenceBuilder.build();
            this.params.getContext().setReferences(defaultReferences);
        } else {
            ReferenceVerifier referenceVerifier = new ReferenceVerifier(this.params);
            referenceVerifier.checkReferencesValidity();
        }
    }

    private ReferenceBuilder initReferenceBuilder() {
        List<DSSDocument> detachedContent = this.documents;
        ReferenceIdProvider referenceIdProvider = new ReferenceIdProvider();
        referenceIdProvider.setSignatureParameters(this.params);
        return new ReferenceBuilder(detachedContent, this.params, referenceIdProvider);
    }

    private void checkSignaturePackagingValidity() {
        if (!SignaturePackaging.ENVELOPING.equals((Object)this.params.getSignaturePackaging())) {
            if (this.params.isManifestSignature()) {
                throw new IllegalArgumentException(String.format("The signature packaging %s is not compatible with manifestSignature(true) configuration!", new Object[]{this.params.getSignaturePackaging()}));
            }
            if (this.params.isEmbedXML()) {
                throw new IllegalArgumentException(String.format("The signature packaging %s is not compatible with embedXML(true) configuration!", new Object[]{this.params.getSignaturePackaging()}));
            }
        }
    }

    protected void incorporateFiles() {
    }

    protected void initRootDocumentDom() {
        if (this.documentDom == null) {
            this.documentDom = this.buildRootDocumentDom();
        }
    }

    protected Document buildRootDocumentDom() {
        return DomUtils.buildDOM();
    }

    public void incorporateSignatureDom() {
        this.signatureDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.SIGNATURE);
        DomUtils.addNamespaceAttribute(this.signatureDom, this.getXmldsigNamespace());
        this.signatureDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), this.deterministicId);
        Node parentNodeOfSignature = this.getParentNodeOfSignature();
        this.incorporateSignatureDom(parentNodeOfSignature);
    }

    protected Node getParentNodeOfSignature() {
        return this.documentDom;
    }

    protected void incorporateSignatureDom(Node parentNodeOfSignature) {
        parentNodeOfSignature.appendChild(this.signatureDom);
    }

    public void incorporateSignedInfo() {
        if (Utils.isArrayNotEmpty(this.params.getSignedData())) {
            LOG.debug("Using explicit SignedInfo from parameter");
            this.signedInfoDom = DomUtils.buildDOM(this.params.getSignedData()).getDocumentElement();
            this.signedInfoDom = (Element)this.documentDom.importNode(this.signedInfoDom, true);
            this.signatureDom.appendChild(this.signedInfoDom);
            return;
        }
        this.signedInfoDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.SIGNED_INFO);
        this.signatureDom.appendChild(this.signedInfoDom);
        this.incorporateCanonicalizationMethod(this.signedInfoDom, this.signedInfoCanonicalizationMethod);
        Element signatureMethod = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.SIGNATURE_METHOD);
        this.signedInfoDom.appendChild(signatureMethod);
        SignatureAlgorithm signatureAlgorithm = this.params.getSignatureAlgorithm();
        String signatureAlgorithmXMLId = signatureAlgorithm.getUri();
        if (Utils.isStringBlank(signatureAlgorithmXMLId)) {
            throw new UnsupportedOperationException("Unsupported signature algorithm " + signatureAlgorithm);
        }
        signatureMethod.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signatureAlgorithmXMLId);
    }

    private void incorporateCanonicalizationMethod(Element parentDom, String signedInfoCanonicalizationMethod) {
        Element canonicalizationMethodDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.CANONICALIZATION_METHOD);
        parentDom.appendChild(canonicalizationMethodDom);
        canonicalizationMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signedInfoCanonicalizationMethod);
    }

    private void incorporateReferences() {
        ReferenceProcessor referenceProcessor = new ReferenceProcessor(this.params);
        referenceProcessor.incorporateReferences(this.signedInfoDom, this.params.getReferences(), this.getXmldsigNamespace());
    }

    protected void incorporateKeyInfo() throws DSSException {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            LOG.debug("Signing certificate not available and must be added to signature DOM later");
            return;
        }
        Element keyInfoElement = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.KEY_INFO);
        this.signatureDom.appendChild(keyInfoElement);
        if (this.params.isSignKeyInfo()) {
            keyInfoElement.setAttribute(XMLDSigAttribute.ID.getAttributeName(), KEYINFO_PREFIX + this.deterministicId);
        }
        List<CertificateToken> certificates = new BaselineBCertificateSelector(this.params.getSigningCertificate(), this.params.getCertificateChain()).setTrustedCertificateSource(this.certificateVerifier.getTrustedCertSources()).setTrustAnchorBPPolicy(this.params.bLevel().isTrustAnchorBPPolicy()).getCertificates();
        if (this.params.isAddX509SubjectName()) {
            for (CertificateToken token : certificates) {
                Element x509DataDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.X509_DATA);
                keyInfoElement.appendChild(x509DataDom);
                this.addSubjectAndCertificate(x509DataDom, token);
            }
        } else {
            Element x509DataDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.X509_DATA);
            keyInfoElement.appendChild(x509DataDom);
            for (CertificateToken token : certificates) {
                this.addCertificate(x509DataDom, token);
            }
        }
        this.keyInfoDom = keyInfoElement;
    }

    private void addSubjectAndCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement(this.documentDom, x509DataDom, this.getXmldsigNamespace(), XMLDSigElement.X509_SUBJECT_NAME, token.getSubject().getRFC2253());
        this.addCertificate(x509DataDom, token);
    }

    private void addCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement(this.documentDom, x509DataDom, this.getXmldsigNamespace(), XMLDSigElement.X509_CERTIFICATE, Utils.toBase64(token.getEncoded()));
    }

    protected void incorporateObjects() {
        this.incorporateQualifyingProperties();
        this.incorporateSignedObjects();
        this.incorporateCustomObjects();
    }

    protected void incorporateQualifyingProperties() {
        if (Utils.isArrayNotEmpty(this.params.getSignedAdESObject())) {
            LOG.debug("Incorporating signed XAdES Object from parameter");
            if (!DomUtils.isDOM(this.params.getSignedAdESObject())) {
                throw new IllegalArgumentException("The signed AdES Object shall represent an XML!");
            }
            Node signedObjectDom = DomUtils.buildDOM(this.params.getSignedAdESObject()).getDocumentElement();
            signedObjectDom = this.documentDom.importNode(signedObjectDom, true);
            this.signatureDom.appendChild(signedObjectDom);
            return;
        }
        Element objectDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.OBJECT);
        this.signatureDom.appendChild(objectDom);
        this.qualifyingPropertiesDom = DomUtils.addElement(this.documentDom, objectDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementQualifyingProperties());
        DomUtils.addNamespaceAttribute(this.qualifyingPropertiesDom, this.getXadesNamespace());
        this.qualifyingPropertiesDom.setAttribute("Target", DomUtils.toElementReference(this.deterministicId));
        this.incorporateSignedProperties();
    }

    protected void incorporateSignedObjects() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            if (reference.getObject() == null) continue;
            this.incorporateObject(reference.getObject());
        }
    }

    protected void incorporateCustomObjects() {
        if (Utils.isCollectionNotEmpty(this.params.getObjects())) {
            for (DSSObject object : this.params.getObjects()) {
                this.incorporateObject(object);
            }
        }
    }

    protected void incorporateObject(DSSObject object) {
        if (object.getContent() == null) {
            throw new IllegalArgumentException("The content shall be defined inside DSSObject element! Incorporation is not possible.");
        }
        Element objectDom = DomUtils.addElement(this.documentDom, this.signatureDom, this.getXmldsigNamespace(), XMLDSigElement.OBJECT);
        if (DomUtils.isDOM(object.getContent())) {
            Document contentDom = DomUtils.buildDOM(object.getContent());
            DomUtils.adoptChildren(objectDom, contentDom);
        } else {
            Text objectContentDom = this.documentDom.createTextNode(new String(DSSUtils.toByteArray(object.getContent())));
            objectDom.appendChild(objectContentDom);
        }
        if (Utils.isStringNotBlank(object.getId())) {
            objectDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), object.getId());
        }
        if (Utils.isStringNotBlank(object.getMimeType())) {
            objectDom.setAttribute(XMLDSigAttribute.MIME_TYPE.getAttributeName(), object.getMimeType());
        }
        if (Utils.isStringNotBlank(object.getEncodingAlgorithm())) {
            objectDom.setAttribute(XMLDSigAttribute.ENCODING.getAttributeName(), object.getEncodingAlgorithm());
        }
    }

    protected void incorporateReferenceSignedProperties() {
        Element reference = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.REFERENCE);
        this.signedInfoDom.appendChild(reference);
        reference.setAttribute(XMLDSigAttribute.TYPE.getAttributeName(), this.xadesPath.getSignedPropertiesUri());
        reference.setAttribute(XMLDSigAttribute.URI.getAttributeName(), DomUtils.toElementReference(XADES_PREFIX + this.deterministicId));
        Element transforms = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORMS);
        reference.appendChild(transforms);
        Element transform = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORM);
        transforms.appendChild(transform);
        transform.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.signedPropertiesCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = DSSXMLUtils.getReferenceDigestAlgorithmOrDefault(this.params);
        DSSXMLUtils.incorporateDigestMethod(reference, digestAlgorithm, this.getXmldsigNamespace());
        if (this.getXmldsigNamespace().getPrefix() != null && this.getXmldsigNamespace().getPrefix().equals(this.getXadesNamespace().getPrefix())) {
            this.signedPropertiesDom = DSSXMLUtils.ensureNamespacesDefined(this.documentDom, this.deterministicId, this.xadesPath.getSignedPropertiesPath());
        }
        byte[] digestValue = DSSXMLUtils.getDigestOnCanonicalizedNode(this.getNodeToCanonicalize(this.signedPropertiesDom), digestAlgorithm, this.signedPropertiesCanonicalizationMethod).getValue();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method REF_SigProps  --> {}", (Object)this.signedPropertiesCanonicalizationMethod);
            LOG.trace("Digest on canonicalized REF_SigProps  --> {}", (Object)Utils.toHex(digestValue));
        }
        this.incorporateDigestValueOfReference(reference, digestValue);
    }

    protected void incorporateReferenceKeyInfo() {
        if (!this.params.isSignKeyInfo()) {
            return;
        }
        Element reference = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.REFERENCE);
        this.signedInfoDom.appendChild(reference);
        reference.setAttribute(XMLDSigAttribute.ID.getAttributeName(), "r-keyInfo-" + this.deterministicId);
        reference.setAttribute(XMLDSigAttribute.URI.getAttributeName(), DomUtils.toElementReference(KEYINFO_PREFIX + this.deterministicId));
        Element transforms = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORMS);
        reference.appendChild(transforms);
        Element transform = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORM);
        transforms.appendChild(transform);
        transform.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.keyInfoCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = DSSXMLUtils.getReferenceDigestAlgorithmOrDefault(this.params);
        DSSXMLUtils.incorporateDigestMethod(reference, digestAlgorithm, this.getXmldsigNamespace());
        byte[] digestValue = DSSXMLUtils.getDigestOnCanonicalizedNode(this.getNodeToCanonicalize(this.keyInfoDom), digestAlgorithm, this.keyInfoCanonicalizationMethod).getValue();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method REF_KeyInfo --> {}", (Object)this.keyInfoCanonicalizationMethod);
            LOG.trace("Digest on canonicalized REF_KeyInfo --> {}", (Object)Utils.toHex(digestValue));
        }
        this.incorporateDigestValueOfReference(reference, digestValue);
    }

    private void incorporateDigestValueOfReference(Element referenceDom, byte[] digestValue) {
        Element digestValueDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.DIGEST_VALUE);
        String base64EncodedDigestBytes = Utils.toBase64(digestValue);
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        referenceDom.appendChild(digestValueDom);
    }

    protected void incorporateSignatureValue() {
        this.signatureValueDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.SIGNATURE_VALUE);
        this.signatureDom.appendChild(this.signatureValueDom);
        this.signatureValueDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), VALUE_PREFIX + this.deterministicId);
    }

    protected void incorporateSignedProperties() {
        this.signedPropertiesDom = DomUtils.addElement(this.documentDom, this.qualifyingPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedProperties());
        this.signedPropertiesDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), XADES_PREFIX + this.deterministicId);
        this.incorporateSignedSignatureProperties();
        this.incorporateSignedDataObjectProperties();
    }

    protected void incorporateSignedSignatureProperties() {
        this.signedSignaturePropertiesDom = DomUtils.addElement(this.documentDom, this.signedPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedSignatureProperties());
        this.incorporateSigningTime();
        this.incorporateSigningCertificate();
        this.incorporatePolicy();
        this.incorporateSignatureProductionPlace();
        this.incorporateSignerRole();
    }

    private void incorporatePolicy() {
        Policy signaturePolicy = this.params.bLevel().getSignaturePolicy();
        if (signaturePolicy != null) {
            Element signaturePolicyIdentifierDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignaturePolicyIdentifier());
            String signaturePolicyId = signaturePolicy.getId();
            if (Utils.isStringEmpty(signaturePolicyId)) {
                DomUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignaturePolicyImplied());
            } else {
                Object[] documentationReferences;
                String description;
                Element signaturePolicyIdDom = DomUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignaturePolicyId());
                Element sigPolicyIdDom = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyId());
                Element identifierDom = DomUtils.addTextElement(this.documentDom, sigPolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIdentifier(), signaturePolicyId);
                ObjectIdentifierQualifier qualifier = signaturePolicy.getQualifier();
                if (qualifier != null) {
                    identifierDom.setAttribute(XAdES132Attribute.QUALIFIER.getAttributeName(), qualifier.getValue());
                }
                if (Utils.isStringNotEmpty(description = signaturePolicy.getDescription())) {
                    DomUtils.addTextElement(this.documentDom, sigPolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDescription(), description);
                }
                if (Utils.isArrayNotEmpty(documentationReferences = signaturePolicy.getDocumentationReferences())) {
                    this.incorporateDocumentationReferences(sigPolicyIdDom, (String[])documentationReferences);
                }
                if (signaturePolicy instanceof XmlPolicyWithTransforms) {
                    XmlPolicyWithTransforms xmlPolicy = (XmlPolicyWithTransforms)signaturePolicy;
                    DSSXMLUtils.incorporateTransforms(signaturePolicyIdDom, xmlPolicy.getTransforms(), this.getXmldsigNamespace());
                }
                if (signaturePolicy.getDigestAlgorithm() != null && signaturePolicy.getDigestValue() != null) {
                    Element sigPolicyHashDom = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyHash());
                    DigestAlgorithm digestAlgorithm = signaturePolicy.getDigestAlgorithm();
                    this.incorporateDigestMethod(sigPolicyHashDom, digestAlgorithm);
                    byte[] hashValue = signaturePolicy.getDigestValue();
                    String base64EncodedHashValue = Utils.toBase64(hashValue);
                    this.incorporateDigestValue(sigPolicyHashDom, base64EncodedHashValue);
                }
                if (signaturePolicy.isSPQualifierPresent()) {
                    this.incorporateSigPolicyQualifiers(signaturePolicyIdDom, signaturePolicy);
                }
            }
        }
    }

    private void incorporateSigPolicyQualifiers(Element signaturePolicyIdDom, Policy signaturePolicy) {
        SpDocSpecification spDocSpecification;
        UserNotice userNotice;
        Element sigPolicyQualifiers = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyQualifiers());
        String spUri = signaturePolicy.getSpuri();
        if (Utils.isStringNotEmpty(spUri)) {
            Element sigPolicyQualifier = DomUtils.addElement(this.documentDom, sigPolicyQualifiers, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyQualifier());
            DomUtils.addTextElement(this.documentDom, sigPolicyQualifier, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSPURI(), spUri);
        }
        if ((userNotice = signaturePolicy.getUserNotice()) != null && !userNotice.isEmpty()) {
            String explicitText;
            DSSUtils.assertSPUserNoticeConfigurationValid(userNotice);
            Element sigPolicyQualifier = DomUtils.addElement(this.documentDom, sigPolicyQualifiers, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyQualifier());
            Element spUserNotice = DomUtils.addElement(this.documentDom, sigPolicyQualifier, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSPUserNotice());
            String organization = userNotice.getOrganization();
            int[] noticeNumbers = userNotice.getNoticeNumbers();
            if (Utils.isStringNotEmpty(organization) && noticeNumbers != null && noticeNumbers.length > 0) {
                Element noticeRef = DomUtils.addElement(this.documentDom, spUserNotice, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementNoticeRef());
                DomUtils.addTextElement(this.documentDom, noticeRef, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementOrganization(), organization);
                Element noticeNumbersElement = DomUtils.addElement(this.documentDom, noticeRef, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementNoticeNumbers());
                for (int number : noticeNumbers) {
                    DomUtils.addTextElement(this.documentDom, noticeNumbersElement, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementint(), String.valueOf(number));
                }
            }
            if (Utils.isStringNotEmpty(explicitText = userNotice.getExplicitText())) {
                DomUtils.addTextElement(this.documentDom, spUserNotice, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementExplicitText(), explicitText);
            }
        }
        if ((spDocSpecification = signaturePolicy.getSpDocSpecification()) != null && Utils.isStringNotEmpty(spDocSpecification.getId())) {
            Element sigPolicyQualifier = DomUtils.addElement(this.documentDom, sigPolicyQualifiers, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyQualifier());
            this.incorporateSPDocSpecification(sigPolicyQualifier, spDocSpecification);
        }
    }

    private void incorporateSigningTime() {
        Date signingDate = this.params.bLevel().getSigningDate();
        XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar(signingDate);
        String xmlSigningTime = xmlGregorianCalendar.toXMLFormat();
        Element signingTimeDom = DomUtils.createElementNS(this.documentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigningTime());
        this.signedSignaturePropertiesDom.appendChild(signingTimeDom);
        Text textNode = this.documentDom.createTextNode(xmlSigningTime);
        signingTimeDom.appendChild(textNode);
    }

    private void incorporateSigningCertificate() {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            return;
        }
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        certificates.add(this.params.getSigningCertificate());
        if (this.params.isEn319132()) {
            this.incorporateSigningCertificateV2(certificates);
        } else {
            this.incorporateSigningCertificateV1(certificates);
        }
    }

    private void incorporateSigningCertificateV1(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigningCertificate());
        DigestAlgorithm signingCertificateDigestMethod = this.params.getSigningCertificateDigestMethod();
        for (CertificateToken certificate : certificates) {
            this.incorporateCert(signingCertificateDom, certificate, signingCertificateDigestMethod);
        }
    }

    private void incorporateSigningCertificateV2(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigningCertificateV2());
        DigestAlgorithm signingCertificateDigestMethod = this.params.getSigningCertificateDigestMethod();
        for (CertificateToken certificate : certificates) {
            this.incorporateCert(signingCertificateDom, certificate, signingCertificateDigestMethod);
        }
    }

    private void incorporateSignedDataObjectProperties() {
        this.incorporateDataObjectFormat();
        this.incorporateCommitmentTypeIndications();
        this.incorporateContentTimestamps();
    }

    private Element getSignedDataObjectPropertiesDom() {
        if (this.signedDataObjectPropertiesDom == null) {
            this.signedDataObjectPropertiesDom = DomUtils.addElement(this.documentDom, this.signedPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedDataObjectProperties());
        }
        return this.signedDataObjectPropertiesDom;
    }

    private void incorporateDataObjectFormat() {
        List<DSSDataObjectFormat> dataObjectFormats = this.params.getDataObjectFormatList();
        if (dataObjectFormats == null) {
            dataObjectFormats = new DataObjectFormatBuilder().setReferences(this.params.getReferences()).build();
            if (this.params.isSignKeyInfo()) {
                DSSDataObjectFormat keyInfoDataObjectFormat = this.getKeyInfoDataObjectFormat();
                dataObjectFormats.add(keyInfoDataObjectFormat);
            }
        }
        for (DSSDataObjectFormat dataObjectFormat : dataObjectFormats) {
            this.assertDataObjectFormatValid(dataObjectFormat);
            Element dataObjectFormatDom = DomUtils.addElement(this.documentDom, this.getSignedDataObjectPropertiesDom(), this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDataObjectFormat());
            if (dataObjectFormat.getDescription() != null) {
                Element descriptionDom = DomUtils.addElement(this.documentDom, dataObjectFormatDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDescription());
                DomUtils.setTextNode(this.documentDom, descriptionDom, dataObjectFormat.getDescription());
            }
            if (dataObjectFormat.getObjectIdentifier() != null) {
                Element objectIdentifierDom = DomUtils.addElement(this.documentDom, dataObjectFormatDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementObjectIdentifier());
                this.incorporateObjectIdentifier(objectIdentifierDom, dataObjectFormat.getObjectIdentifier());
            }
            if (dataObjectFormat.getMimeType() != null) {
                Element mimeTypeDom = DomUtils.addElement(this.documentDom, dataObjectFormatDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementMimeType());
                DomUtils.setTextNode(this.documentDom, mimeTypeDom, dataObjectFormat.getMimeType());
            }
            if (dataObjectFormat.getEncoding() != null) {
                Element encodingDom = DomUtils.addElement(this.documentDom, dataObjectFormatDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementEncoding());
                DomUtils.setTextNode(this.documentDom, encodingDom, dataObjectFormat.getEncoding());
            }
            if (dataObjectFormat.getObjectReference() == null) continue;
            dataObjectFormatDom.setAttribute(XAdES132Attribute.OBJECT_REFERENCE.getAttributeName(), dataObjectFormat.getObjectReference());
        }
    }

    private DSSDataObjectFormat getKeyInfoDataObjectFormat() {
        DSSDataObjectFormat keyInfoDataObjectFormat = new DSSDataObjectFormat();
        keyInfoDataObjectFormat.setObjectReference(DomUtils.toElementReference("r-keyInfo-" + this.deterministicId));
        keyInfoDataObjectFormat.setMimeType(MimeTypeEnum.XML.getMimeTypeString());
        return keyInfoDataObjectFormat;
    }

    private void assertDataObjectFormatValid(DSSDataObjectFormat dataObjectFormat) {
        Objects.requireNonNull(dataObjectFormat, "DataObjectFormat cannot be null!");
        if (dataObjectFormat.getDescription() == null && dataObjectFormat.getObjectIdentifier() == null && dataObjectFormat.getMimeType() == null) {
            throw new IllegalArgumentException("At least one of the Description, ObjectIdentifier or MimeType shall be defined for a DataObjectFormat object!");
        }
        if (dataObjectFormat.getObjectReference() == null) {
            throw new IllegalArgumentException("ObjectReference attribute of DataObjectFormat shall be present!");
        }
        if (!DomUtils.isElementReference(dataObjectFormat.getObjectReference())) {
            throw new IllegalArgumentException("ObjectReference attribute of DataObjectFormat shall define a reference to an element within signature (i.e. shall begin with '#')!");
        }
    }

    private void incorporateContentTimestamps() {
        List<TimestampToken> contentTimestamps = this.params.getContentTimestamps();
        if (contentTimestamps == null) {
            return;
        }
        for (TimestampToken contentTimestamp : contentTimestamps) {
            Element timestampDom;
            TimestampType timeStampType = contentTimestamp.getTimeStampType();
            if (TimestampType.ALL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                timestampDom = DomUtils.addElement(this.documentDom, this.getSignedDataObjectPropertiesDom(), this.getXadesNamespace(), this.getCurrentXAdESElements().getElementAllDataObjectsTimeStamp());
            } else if (TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                timestampDom = DomUtils.addElement(this.documentDom, this.getSignedDataObjectPropertiesDom(), this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIndividualDataObjectsTimeStamp());
            } else {
                throw new UnsupportedOperationException("Only types ALL_DATA_OBJECTS_TIMESTAMP and INDIVIDUAL_DATA_OBJECTS_TIMESTAMP are allowed");
            }
            this.addContentTimestamp(timestampDom, contentTimestamp);
        }
    }

    private void incorporateSignerRole() {
        List<String> claimedSignerRoles = this.params.bLevel().getClaimedSignerRoles();
        List<String> signedAssertions = this.params.bLevel().getSignedAssertions();
        Element signerRoleDom = null;
        if (claimedSignerRoles != null) {
            signerRoleDom = this.params.isEn319132() ? DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignerRoleV2()) : DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignerRole());
            if (Utils.isCollectionNotEmpty(claimedSignerRoles)) {
                Element claimedRolesDom = DomUtils.addElement(this.documentDom, signerRoleDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementClaimedRoles());
                this.addRoles(claimedSignerRoles, claimedRolesDom, this.getCurrentXAdESElements().getElementClaimedRole());
            }
        }
        if (signedAssertions != null && this.params.isEn319132()) {
            if (signerRoleDom == null) {
                signerRoleDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignerRoleV2());
            }
            if (Utils.isCollectionNotEmpty(signedAssertions)) {
                Element signedAssertionsDom = DomUtils.addElement(this.documentDom, signerRoleDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedAssertions());
                this.addAssertions(signedAssertions, signedAssertionsDom);
            }
        }
    }

    private void addRoles(List<String> signerRoles, Element rolesDom, DSSElement roleType) {
        for (String signerRole : signerRoles) {
            Element roleDom = DomUtils.addElement(this.documentDom, rolesDom, this.getXadesNamespace(), roleType);
            DomUtils.setTextNode(this.documentDom, roleDom, signerRole);
        }
    }

    private void incorporateSignatureProductionPlace() {
        SignerLocation signatureProductionPlace = this.params.bLevel().getSignerLocation();
        if (signatureProductionPlace != null && !signatureProductionPlace.isEmpty()) {
            String country;
            String postalCode;
            String stateOrProvince;
            String streetAddress;
            Element signatureProductionPlaceDom = this.params.isEn319132() ? DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignatureProductionPlaceV2()) : DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignatureProductionPlace());
            String city = signatureProductionPlace.getLocality();
            if (city != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCity(), city);
            }
            if (this.params.isEn319132() && (streetAddress = signatureProductionPlace.getStreetAddress()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementStreetAddress(), streetAddress);
            }
            if ((stateOrProvince = signatureProductionPlace.getStateOrProvince()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementStateOrProvince(), stateOrProvince);
            }
            if ((postalCode = signatureProductionPlace.getPostalCode()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementPostalCode(), postalCode);
            }
            if ((country = signatureProductionPlace.getCountry()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCountryName(), country);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void incorporateCommitmentTypeIndications() {
        List<CommitmentType> commitmentTypeIndications = this.params.bLevel().getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            for (CommitmentType commitmentTypeIndication : commitmentTypeIndications) {
                void var11_15;
                this.assertCommitmentTypeNotNull(commitmentTypeIndication);
                Element commitmentTypeIndicationDom = DomUtils.addElement(this.documentDom, this.getSignedDataObjectPropertiesDom(), this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCommitmentTypeIndication());
                Element commitmentTypeIdDom = DomUtils.addElement(this.documentDom, commitmentTypeIndicationDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCommitmentTypeId());
                this.incorporateObjectIdentifier(commitmentTypeIdDom, commitmentTypeIndication);
                String[] signedDataObjects = null;
                Object[] commitmentTypeQualifiers = null;
                if (commitmentTypeIndication instanceof CommonCommitmentType) {
                    CommonCommitmentType commonCommitmentType = (CommonCommitmentType)commitmentTypeIndication;
                    signedDataObjects = commonCommitmentType.getSignedDataObjects();
                    commitmentTypeQualifiers = commonCommitmentType.getCommitmentTypeQualifiers();
                }
                if (Utils.isArrayNotEmpty(signedDataObjects)) {
                    for (CommonCommitmentType commonCommitmentType : signedDataObjects) {
                        if (Utils.isStringBlank((String)((Object)commonCommitmentType))) {
                            throw new IllegalArgumentException("SignedDataObject URI cannot be null!");
                        }
                        String string = DomUtils.toElementReference((String)((Object)commonCommitmentType));
                        DomUtils.addTextElement(this.documentDom, commitmentTypeIndicationDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementObjectReference(), string);
                    }
                } else {
                    DomUtils.addElement(this.documentDom, commitmentTypeIndicationDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementAllSignedDataObjects());
                }
                if (!Utils.isArrayNotEmpty(commitmentTypeQualifiers)) continue;
                Element commitmentTypeQualifiersElement = DomUtils.addElement(this.documentDom, commitmentTypeIndicationDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCommitmentTypeQualifiers());
                Object[] objectArray = commitmentTypeQualifiers;
                int n = objectArray.length;
                boolean bl = false;
                while (var11_15 < n) {
                    Node objectContentDom;
                    Object commitmentQualifier = objectArray[var11_15];
                    Objects.requireNonNull(commitmentQualifier, "CommitmentTypeQualifier cannot be null!");
                    DSSDocument content = ((CommitmentQualifier)commitmentQualifier).getContent();
                    if (content == null) {
                        throw new IllegalArgumentException("CommitmentTypeQualifier content cannot be null!");
                    }
                    Element commitmentTypeQualifierElement = DomUtils.addElement(this.documentDom, commitmentTypeQualifiersElement, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCommitmentTypeQualifier());
                    if (DomUtils.isDOM(content)) {
                        objectContentDom = DomUtils.buildDOM(content).getDocumentElement();
                        objectContentDom = this.documentDom.importNode(objectContentDom, true);
                    } else {
                        LOG.info("None XML encoded CommitmentTypeQualifier has been provided. Incorporate as text node.");
                        objectContentDom = this.documentDom.createTextNode(new String(DSSUtils.toByteArray(content)));
                    }
                    commitmentTypeQualifierElement.appendChild(objectContentDom);
                    ++var11_15;
                }
            }
        }
    }

    private void assertCommitmentTypeNotNull(CommitmentType commitmentType) {
        Objects.requireNonNull(commitmentType, "CommitmentType cannot be null!");
        if (commitmentType.getUri() == null && commitmentType.getOid() == null) {
            throw new IllegalArgumentException("The URI or OID must be defined for commitmentTypeIndication for XAdES creation!");
        }
    }

    private void incorporateObjectIdentifier(Element parentDom, ObjectIdentifier objectIdentifier) {
        Object[] documentationReferences;
        this.incorporateIdentifier(parentDom, objectIdentifier);
        String description = objectIdentifier.getDescription();
        if (description != null) {
            DomUtils.addTextElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDescription(), description);
        }
        if (Utils.isArrayNotEmpty(documentationReferences = objectIdentifier.getDocumentationReferences())) {
            this.incorporateDocumentationReferences(parentDom, (String[])documentationReferences);
        }
    }

    private void incorporateIdentifier(Element parentDom, ObjectIdentifier objectIdentifier) {
        String uri = objectIdentifier.getUri();
        String oid = objectIdentifier.getOid();
        ObjectIdentifierQualifier qualifier = objectIdentifier.getQualifier();
        if (Utils.isStringEmpty(uri)) {
            if (Utils.isStringEmpty(oid)) {
                throw new IllegalArgumentException("The URI or OID must be defined for XAdES IdentifierType element!");
            }
            if (qualifier == null) {
                throw new IllegalArgumentException("When using OID as object identifier in XAdES, a Qualifier shall be provided! See EN 319 132-1 for more details.");
            }
            switch (qualifier) {
                case OID_AS_URI: {
                    if (!DSSUtils.isUrnOid(oid)) break;
                    throw new IllegalArgumentException(String.format("Qualifier '%s' shall not be used for URN encoded OID! See EN 319 132-1 for more details.", new Object[]{qualifier}));
                }
                case OID_AS_URN: {
                    if (DSSUtils.isUrnOid(oid)) break;
                    oid = DSSUtils.toUrnOid(oid);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("The Qualifier '%s' is not supported!", new Object[]{qualifier}));
                }
            }
            uri = oid;
        } else if (qualifier != null) {
            throw new IllegalArgumentException("When using URI as object identifier in XAdES, a Qualifier shall not be present! See EN 319 132-1 for more details.");
        }
        Element identifierDom = DomUtils.addTextElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIdentifier(), uri);
        if (qualifier != null) {
            identifierDom.setAttribute(XAdES132Attribute.QUALIFIER.getAttributeName(), qualifier.getValue());
        }
    }

    private void incorporateDocumentationReferences(Element parentElement, String[] documentationReferences) {
        Element documentReferencesDom = DomUtils.addElement(this.documentDom, parentElement, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDocumentationReferences());
        for (String ref : documentationReferences) {
            DomUtils.addTextElement(this.documentDom, documentReferencesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDocumentationReference(), ref);
        }
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSASN1Utils.ensurePlainSignatureValue(encryptionAlgorithm, signatureValue);
        String signatureValueBase64Encoded = Utils.toBase64(signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        return this.createXmlDocument();
    }

    protected void addContentTimestamp(Element timestampElement, TimestampToken token) {
        String canonicalizationMethod;
        List<TimestampInclude> includes = token.getTimestampIncludes();
        if (includes != null) {
            for (TimestampInclude include : includes) {
                Element timestampIncludeElement = DomUtils.createElementNS(this.documentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementInclude());
                String uri = DomUtils.toElementReference(include.getURI());
                timestampIncludeElement.setAttribute("URI", uri);
                timestampIncludeElement.setAttribute("referencedData", "true");
                timestampElement.appendChild(timestampIncludeElement);
            }
        }
        if (!Utils.isStringNotEmpty(canonicalizationMethod = token.getCanonicalizationMethod())) {
            throw new IllegalArgumentException("Unable to create a timestamp with empty canonicalization method. See EN 319 132-1: 4.5 Managing canonicalization of XML nodesets.");
        }
        Element canonicalizationMethodElement = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.CANONICALIZATION_METHOD);
        canonicalizationMethodElement.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), canonicalizationMethod);
        timestampElement.appendChild(canonicalizationMethodElement);
        Element encapsulatedTimestampElement = DomUtils.createElementNS(this.documentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementEncapsulatedTimeStamp());
        encapsulatedTimestampElement.setTextContent(Utils.toBase64(token.getEncoded()));
        timestampElement.appendChild(encapsulatedTimestampElement);
        String timestampId = "ts-" + this.toXmlIdentifier(XAdESAttributeIdentifier.build(timestampElement));
        timestampElement.setAttribute(XMLDSigAttribute.ID.getAttributeName(), timestampId);
        encapsulatedTimestampElement.setAttribute(XMLDSigAttribute.ID.getAttributeName(), "ets-" + timestampId);
    }

    protected Node getNodeToCanonicalize(Node node) {
        if (this.params.isPrettyPrint()) {
            return DSSXMLUtils.getIndentedNode(this.documentDom, node);
        }
        return node;
    }

    @Override
    protected void alignNodes() {
        if (this.unsignedSignaturePropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.unsignedSignaturePropertiesDom);
        }
        if (this.qualifyingPropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.qualifyingPropertiesDom);
        }
    }

    private void addAssertions(List<String> signedAssertions, Element rolesDom) {
        for (String signedAssertion : signedAssertions) {
            Element roleDom = DomUtils.addElement(this.documentDom, rolesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedAssertion());
            Document samlAssertion = DomUtils.buildDOM(signedAssertion);
            Element docEl = samlAssertion.getDocumentElement();
            Node node = this.documentDom.importNode(docEl, true);
            roleDom.appendChild(node);
        }
    }
}

