/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.diagnostic;

import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlConnectionInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTLSCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTLSCertificateBindingSignature;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.validation.reports.diagnostic.SignedDocumentDiagnosticDataBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

public class QWACCertificateDiagnosticDataBuilder
extends SignedDocumentDiagnosticDataBuilder {
    private String websiteUrl;
    private CertificateToken tlsCertificate;
    private String tlsCertificateBindingUrl;
    private AdvancedSignature tlsCertificateBindingSignature;
    private SignedDocumentDiagnosticDataBuilder signatureDiagnosticDataBuilder;

    public QWACCertificateDiagnosticDataBuilder websiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
        return this;
    }

    public QWACCertificateDiagnosticDataBuilder tlsCertificate(CertificateToken tlsCertificate) {
        this.tlsCertificate = tlsCertificate;
        return this;
    }

    public QWACCertificateDiagnosticDataBuilder tlsCertificateBindingUrl(String tlsCertificateBindingUrl) {
        this.tlsCertificateBindingUrl = tlsCertificateBindingUrl;
        return this;
    }

    public QWACCertificateDiagnosticDataBuilder tlsCertificateBindingSignature(AdvancedSignature tlsCertificateBindingSignature) {
        this.tlsCertificateBindingSignature = tlsCertificateBindingSignature;
        return this;
    }

    public QWACCertificateDiagnosticDataBuilder setSignatureDiagnosticDataBuilder(SignedDocumentDiagnosticDataBuilder signatureDiagnosticDataBuilder) {
        this.signatureDiagnosticDataBuilder = signatureDiagnosticDataBuilder;
        return this;
    }

    @Override
    public XmlDiagnosticData build() {
        XmlDiagnosticData xmlDiagnosticData = super.build();
        xmlDiagnosticData.setConnectionInfo(this.buildXmlConnectionInfo());
        return xmlDiagnosticData;
    }

    private XmlConnectionInfo buildXmlConnectionInfo() {
        XmlConnectionInfo xmlConnectionInfo = new XmlConnectionInfo();
        if (this.websiteUrl != null) {
            xmlConnectionInfo.setUrl(this.websiteUrl);
        }
        if (this.tlsCertificate != null) {
            XmlTLSCertificate xmlTLSCertificate = new XmlTLSCertificate();
            xmlTLSCertificate.setCertificate((XmlCertificate)this.xmlCertsMap.get(this.tlsCertificate.getDSSIdAsString()));
            xmlConnectionInfo.setTLSCertificate(xmlTLSCertificate);
        }
        if (this.tlsCertificateBindingUrl != null) {
            xmlConnectionInfo.setTLSCertificateBindingUrl(this.tlsCertificateBindingUrl);
        }
        if (this.tlsCertificateBindingSignature != null) {
            XmlTLSCertificateBindingSignature xmlTLSCertificateBindingSignature = new XmlTLSCertificateBindingSignature();
            xmlTLSCertificateBindingSignature.setSignature((XmlSignature)this.xmlSignaturesMap.get(this.tlsCertificateBindingSignature.getId()));
            xmlConnectionInfo.setTLSCertificateBindingSignature(xmlTLSCertificateBindingSignature);
        }
        return xmlConnectionInfo;
    }

    @Override
    public XmlSignature buildDetachedXmlSignature(AdvancedSignature signature) {
        XmlSignature xmlSignature = this.signatureDiagnosticDataBuilder.buildDetachedXmlSignature(signature);
        this.identifyTLSCertificates(xmlSignature);
        return xmlSignature;
    }

    private void identifyTLSCertificates(XmlSignature xmlSignature) {
        for (XmlDigestMatcher digestMatcher : xmlSignature.getDigestMatchers()) {
            CertificateToken tlsCertificate;
            if (DigestMatcherType.SIG_D_ENTRY != digestMatcher.getType() || !digestMatcher.isDataFound() || !digestMatcher.isDataIntact() || (tlsCertificate = this.getMatchingTLSCertificate(digestMatcher)) == null) continue;
            digestMatcher.setDataObjectReferences(Collections.singletonList(this.identifierProvider.getIdAsString(tlsCertificate)));
        }
    }

    private CertificateToken getMatchingTLSCertificate(XmlDigestMatcher digestMatcher) {
        for (CertificateToken certificate : this.usedCertificates) {
            if (!Arrays.equals(digestMatcher.getDigestValue(), certificate.getDigest(digestMatcher.getDigestMethod()))) continue;
            return certificate;
        }
        return null;
    }

    @Override
    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.websiteUrl, "websiteUrl shall be provided!");
    }
}

