/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.qwac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinkHeaderParser {
    public List<LinkHeader> parse(String headerValueStr) {
        if (headerValueStr == null || headerValueStr.trim().isEmpty()) {
            throw new IllegalArgumentException("Link header cannot be null or empty");
        }
        ArrayList<LinkHeader> result = new ArrayList<LinkHeader>();
        List<String> linkValues = this.splitHeaderValues(headerValueStr);
        for (String linkValue : linkValues) {
            LinkHeader header = this.parseSingleLink(linkValue.trim());
            result.add(header);
        }
        return result;
    }

    private List<String> splitHeaderValues(String headerValueStr) {
        ArrayList<String> values2 = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < headerValueStr.length(); ++i) {
            char c = headerValueStr.charAt(i);
            if (c == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == ',' && !inQuotes) {
                values2.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            values2.add(current.toString());
        }
        return values2;
    }

    private LinkHeader parseSingleLink(String headerValueStr) {
        if (!headerValueStr.startsWith("<")) {
            throw new IllegalArgumentException("Link entry must start with '<': " + headerValueStr);
        }
        int urlEnd = headerValueStr.indexOf(62);
        if (urlEnd == -1) {
            throw new IllegalArgumentException("Missing '>' in Link entry: " + headerValueStr);
        }
        String url = headerValueStr.substring(1, urlEnd).trim();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String attributesPart = headerValueStr.substring(urlEnd + 1).trim();
        if (!attributesPart.isEmpty()) {
            String[] parts;
            for (String part : parts = attributesPart.split(";")) {
                if ((part = part.trim()).isEmpty()) continue;
                String[] keyValue = part.split("=", 2);
                if (keyValue.length == 2) {
                    String key = keyValue[0].trim();
                    String value = keyValue[1].trim();
                    value = this.stripQuotes(value);
                    attributes.put(key, value);
                    continue;
                }
                attributes.put(part, null);
            }
        }
        LinkHeader header = new LinkHeader();
        header.setUrl(url);
        header.setAttributes(attributes);
        return header;
    }

    private String stripQuotes(String value) {
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static class LinkHeader
    implements Serializable {
        private static final long serialVersionUID = 5652555158066131132L;
        private String url;
        private Map<String, String> attributes;

        protected LinkHeader() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }
    }
}

