/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.OrphanTokenWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.SignerDataWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.vpfswatsp.EvidenceRecordPOE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEComparator;
import eu.europa.esig.dss.validation.process.vpfswatsp.TimestampPOE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class POEExtraction {
    private final Map<String, List<POE>> poeMap = new HashMap<String, List<POE>>();

    public void init(DiagnosticData diagnosticData, Date controlTime) {
        POE controlTimePoe = new POE(controlTime);
        for (SignatureWrapper signatureWrapper : diagnosticData.getAllSignatures()) {
            this.addPOE(signatureWrapper.getId(), controlTimePoe);
        }
        for (TimestampWrapper timestampWrapper : diagnosticData.getTimestampList()) {
            this.addPOE(timestampWrapper.getId(), controlTimePoe);
        }
        for (EvidenceRecordWrapper evidenceRecordWrapper : diagnosticData.getEvidenceRecords()) {
            this.addPOE(evidenceRecordWrapper.getId(), controlTimePoe);
        }
        for (CertificateWrapper certificateWrapper : diagnosticData.getUsedCertificates()) {
            this.addPOE(certificateWrapper.getId(), controlTimePoe);
        }
        for (RevocationWrapper revocationWrapper : diagnosticData.getAllRevocationData()) {
            this.addPOE(revocationWrapper.getId(), controlTimePoe);
        }
        for (SignerDataWrapper signerDataWrapper : diagnosticData.getAllSignerDocuments()) {
            this.addPOE(signerDataWrapper.getId(), controlTimePoe);
        }
        for (OrphanTokenWrapper orphanTokenWrapper : diagnosticData.getAllOrphanCertificateObjects()) {
            this.addPOE(orphanTokenWrapper.getId(), controlTimePoe);
        }
        for (OrphanTokenWrapper orphanTokenWrapper : diagnosticData.getAllOrphanCertificateReferences()) {
            this.addPOE(orphanTokenWrapper.getId(), controlTimePoe);
        }
        for (OrphanTokenWrapper orphanTokenWrapper : diagnosticData.getAllOrphanRevocationObjects()) {
            this.addPOE(orphanTokenWrapper.getId(), controlTimePoe);
        }
        for (OrphanTokenWrapper orphanTokenWrapper : diagnosticData.getAllOrphanRevocationReferences()) {
            this.addPOE(orphanTokenWrapper.getId(), controlTimePoe);
        }
    }

    public void collectAllPOE(Collection<TimestampWrapper> timestamps) {
        for (TimestampWrapper timestamp : timestamps) {
            this.extractPOE(timestamp);
        }
    }

    public void extractPOE(TimestampWrapper timestamp) {
        List<XmlTimestampedObject> timestampedObjects;
        if (timestamp.isMessageImprintDataFound() && timestamp.isMessageImprintDataIntact() && Utils.isCollectionNotEmpty(timestampedObjects = timestamp.getTimestampedObjects())) {
            TimestampPOE poe = new TimestampPOE(timestamp);
            for (XmlTimestampedObject xmlTimestampedObject : timestampedObjects) {
                this.addPOE(xmlTimestampedObject.getToken().getId(), poe);
            }
        }
    }

    public void extractPOE(EvidenceRecordWrapper evidenceRecord) {
        List<XmlTimestampedObject> coveredObjects = evidenceRecord.getCoveredObjects();
        if (Utils.isCollectionNotEmpty(coveredObjects)) {
            EvidenceRecordPOE poe = new EvidenceRecordPOE(evidenceRecord);
            for (XmlTimestampedObject xmlTimestampedObject : coveredObjects) {
                this.addPOE(xmlTimestampedObject.getToken().getId(), poe);
            }
        }
    }

    public void extractPOE(List<XmlTimestampedObject> timestampedObjects, Date poeTime) {
        if (Utils.isCollectionNotEmpty(timestampedObjects) && poeTime != null) {
            POE poe = new POE(poeTime);
            for (XmlTimestampedObject xmlTimestampedObject : timestampedObjects) {
                this.addPOE(xmlTimestampedObject.getToken().getId(), poe);
            }
        }
    }

    private void addPOE(String tokenId, POE proofOfExistence) {
        if (proofOfExistence != null) {
            List poesById = this.poeMap.computeIfAbsent(tokenId, k -> new ArrayList());
            poesById.add(proofOfExistence);
        }
    }

    public void addSignaturePOE(SignatureWrapper signature, POE proofOfExistence) {
        if (signature != null) {
            this.addPOE(signature.getId(), proofOfExistence);
        }
    }

    public boolean isPOEExists(String tokenId, Date controlTime) {
        List<POE> poes = this.poeMap.get(tokenId);
        if (poes != null) {
            for (POE poe : poes) {
                if (poe.getTime().compareTo(controlTime) > 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPOEExistInRange(String tokenId, Date notBefore, Date notAfter) {
        List<POE> poes = this.poeMap.get(tokenId);
        if (poes != null) {
            for (POE poe : poes) {
                if (poe.getTime().compareTo(notBefore) < 0 || poe.getTime().compareTo(notAfter) > 0) continue;
                return true;
            }
        }
        return false;
    }

    public Date getLowestPOETime(String tokenId) {
        return this.getLowestPOE(tokenId).getTime();
    }

    public POE getLowestPOE(String tokenId) {
        POE lowestPOE = null;
        List<POE> poes = this.poeMap.get(tokenId);
        if (poes != null) {
            POEComparator comparator = new POEComparator();
            for (POE poe : poes) {
                if (lowestPOE != null && !comparator.before(poe, lowestPOE)) continue;
                lowestPOE = poe;
            }
        }
        return lowestPOE;
    }
}

