/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.qwac.QWACUtils;
import java.util.Date;
import java.util.List;

public class TLSCertificateBindingSignatureExpiryDateCheck
extends ChainItem<XmlValidationQWACProcess> {
    private final Date currentTime;
    private final SignatureWrapper signature;
    private final List<CertificateWrapper> certificates;

    public TLSCertificateBindingSignatureExpiryDateCheck(I18nProvider i18nProvider, XmlValidationQWACProcess result, Date currentTime, SignatureWrapper signature, List<CertificateWrapper> certificates, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.currentTime = currentTime;
        this.signature = signature;
        this.certificates = certificates;
    }

    @Override
    protected boolean process() {
        if (this.signature.getExpirationTime() != null && !this.currentTime.before(this.signature.getExpirationTime())) {
            return false;
        }
        for (CertificateWrapper certificate : this.getIdentifiedTLSCertificates()) {
            if (certificate.getNotAfter() == null || this.currentTime.before(certificate.getNotAfter())) continue;
            return false;
        }
        return this.signature.getSigningCertificate() == null || this.signature.getSigningCertificate().getNotAfter() == null || this.currentTime.before(this.signature.getSigningCertificate().getNotAfter());
    }

    private List<CertificateWrapper> getIdentifiedTLSCertificates() {
        return QWACUtils.getIdentifiedTLSCertificates(this.signature, this.certificates);
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.signature.getExpirationTime() != null && !this.currentTime.before(this.signature.getExpirationTime())) {
            return this.i18nProvider.getMessage(MessageTag.QWAC_EXPIRY_EXP, ValidationProcessUtils.getFormattedDate(this.currentTime), ValidationProcessUtils.getFormattedDate(this.signature.getExpirationTime()));
        }
        for (CertificateWrapper certificate : this.getIdentifiedTLSCertificates()) {
            if (certificate.getNotAfter() == null || this.currentTime.before(certificate.getNotAfter())) continue;
            return this.i18nProvider.getMessage(MessageTag.QWAC_EXPIRY_EXP, ValidationProcessUtils.getFormattedDate(this.currentTime), ValidationProcessUtils.getFormattedDate(certificate.getNotAfter()), certificate.getId());
        }
        if (this.signature.getSigningCertificate() != null && this.signature.getSigningCertificate().getNotAfter() != null && !this.currentTime.before(this.signature.getSigningCertificate().getNotAfter())) {
            return this.i18nProvider.getMessage(MessageTag.QWAC_EXPIRY_EXP, ValidationProcessUtils.getFormattedDate(this.currentTime), ValidationProcessUtils.getFormattedDate(this.signature.getSigningCertificate().getNotAfter()), this.signature.getSigningCertificate().getId());
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TLS_CERT_BINDING_SIG_EXPIRY_DATE;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TLS_CERT_BINDING_SIG_EXPIRY_DATE_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

