/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class QualifiedCertificateForWSAAtTimeCheck
extends ChainItem<XmlValidationQWACProcess> {
    private final XmlValidationCertificateQualification certificateQualification;

    public QualifiedCertificateForWSAAtTimeCheck(I18nProvider i18nProvider, XmlValidationQWACProcess result, XmlValidationCertificateQualification certificateQualification, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificateQualification = certificateQualification;
    }

    @Override
    protected boolean process() {
        return CertificateQualification.QCERT_FOR_WSA == this.certificateQualification.getCertificateQualification();
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.QWAC_IS_WSA_AT_TIME, new Object[]{ValidationProcessUtils.getValidationTimeMessageTag(this.certificateQualification.getValidationTime())});
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.QWAC_IS_WSA_AT_TIME_ANS, new Object[]{ValidationProcessUtils.getValidationTimeMessageTag(this.certificateQualification.getValidationTime())});
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.VALIDATION_TIME, ValidationProcessUtils.getFormattedDate(this.certificateQualification.getDateTime()));
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

