/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.enumerations.QWACProfile;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.AcceptableBuildingBlockConclusionCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.QWACDomainNameCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.TLSCertificateBindingPresentInSignatureCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.TLSCertificateBindingQWACCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.TLSCertificateBindingSignatureExpProtectedHeaderPresentCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.TLSCertificateBindingSignatureExpiryDateCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.TLSCertificateBindingSignatureFormatCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.TLSCertificateBindingSignatureFoundCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.TLSCertificateBindingSignatureSerializationTypeCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.TLSCertificateBindingSignatureValidationResultCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.TLSCertificateBindingUrlPresentCheck;

public class TLSCertificateSupportedByQWAC2ValidationProcessBlock
extends Chain<XmlValidationQWACProcess> {
    private final DiagnosticData diagnosticData;
    private final CertificateWrapper tlsCertificate;
    private final XmlConclusion tlsCertificateBasicValidationConclusion;
    private final XmlConclusion bindingSignatureBasicValidationConclusion;
    private final QWACProfile bindingCertificateProfile;
    private final String websiteUrl;

    public TLSCertificateSupportedByQWAC2ValidationProcessBlock(I18nProvider i18nProvider, DiagnosticData diagnosticData, CertificateWrapper tlsCertificate, XmlConclusion tlsCertificateBasicValidationConclusion, XmlConclusion bindingSignatureBasicValidationConclusion, QWACProfile bindingCertificateProfile, String websiteUrl) {
        super(i18nProvider, new XmlValidationQWACProcess());
        ((XmlValidationQWACProcess)this.result).setId(tlsCertificate.getId());
        this.tlsCertificate = tlsCertificate;
        this.diagnosticData = diagnosticData;
        this.tlsCertificateBasicValidationConclusion = tlsCertificateBasicValidationConclusion;
        this.bindingSignatureBasicValidationConclusion = bindingSignatureBasicValidationConclusion;
        this.bindingCertificateProfile = bindingCertificateProfile;
        this.websiteUrl = websiteUrl;
    }

    @Override
    protected String buildChainTitle() {
        MessageTag message = MessageTag.QWAC_VALIDATION_PROFILE;
        MessageTag param = ValidationProcessUtils.getQWACValidationMessageTag(this.getQWACProfile());
        return this.i18nProvider.getMessage(message, new Object[]{param});
    }

    public QWACProfile getQWACProfile() {
        return QWACProfile.TLS_BY_QWAC_2;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlValidationQWACProcess> item = this.firstItem = this.isAcceptableBuildingBlockConclusion();
        item = item.setNextItem(this.qwacDomainName());
        item = item.setNextItem(this.tlsCertificateBindingUrlPresent());
        item = item.setNextItem(this.tlsCertificateBindingSignatureFound());
        if (this.diagnosticData.getTLSCertificateBindingSignature() != null) {
            item = item.setNextItem(this.tlsCertificateBindingSignatureFormat());
            item = item.setNextItem(this.tlsCertificateBindingSignatureSerializationType());
            item = item.setNextItem(this.tlsCertificateBindingSignatureExpProtectedHeaderPresent());
            item = item.setNextItem(this.tlsCertificateBindingSignatureExpiryDate());
            item = item.setNextItem(this.tlsCertificateBindingIsQWAC());
            item = item.setNextItem(this.tlsCertificateBindingSignatureValid());
            item = item.setNextItem(this.tlsCertificateBindingCertificateAppearInSignature());
        }
    }

    private ChainItem<XmlValidationQWACProcess> isAcceptableBuildingBlockConclusion() {
        return new AcceptableBuildingBlockConclusionCheck<XmlValidationQWACProcess>(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.tlsCertificateBasicValidationConclusion, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> qwacDomainName() {
        return new QWACDomainNameCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.tlsCertificate, this.websiteUrl, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> tlsCertificateBindingUrlPresent() {
        return new TLSCertificateBindingUrlPresentCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.diagnosticData.getTLSCertificateBindingUrl(), this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> tlsCertificateBindingSignatureFound() {
        return new TLSCertificateBindingSignatureFoundCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.diagnosticData.getTLSCertificateBindingSignature(), this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> tlsCertificateBindingSignatureFormat() {
        return new TLSCertificateBindingSignatureFormatCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.diagnosticData.getTLSCertificateBindingSignature(), this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> tlsCertificateBindingSignatureSerializationType() {
        return new TLSCertificateBindingSignatureSerializationTypeCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.diagnosticData.getTLSCertificateBindingSignature(), this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> tlsCertificateBindingSignatureExpProtectedHeaderPresent() {
        return new TLSCertificateBindingSignatureExpProtectedHeaderPresentCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.diagnosticData.getTLSCertificateBindingSignature(), this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> tlsCertificateBindingSignatureExpiryDate() {
        return new TLSCertificateBindingSignatureExpiryDateCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.diagnosticData.getValidationDate(), this.diagnosticData.getTLSCertificateBindingSignature(), this.diagnosticData.getUsedCertificates(), this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> tlsCertificateBindingIsQWAC() {
        return new TLSCertificateBindingQWACCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.bindingCertificateProfile, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> tlsCertificateBindingSignatureValid() {
        return new TLSCertificateBindingSignatureValidationResultCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.bindingSignatureBasicValidationConclusion, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> tlsCertificateBindingCertificateAppearInSignature() {
        return new TLSCertificateBindingPresentInSignatureCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.tlsCertificate, this.diagnosticData.getTLSCertificateBindingSignature(), this.getFailLevelRule());
    }
}

