/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExtendedKeyUsageCheck
extends AbstractMultiValuesCheckItem<XmlSubXCV> {
    private final CertificateWrapper certificate;
    private final Context context;
    private final SubContext subContext;

    public ExtendedKeyUsageCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, Context context, SubContext subContext, MultiValuesRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.context = context;
        this.subContext = subContext;
    }

    @Override
    protected boolean process() {
        return this.processValuesCheck(this.getExtendedKeyUsageDescriptions());
    }

    private List<String> getExtendedKeyUsageDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        for (XmlOID eku : this.certificate.getExtendedKeyUsages()) {
            result.add(eku.getDescription());
        }
        return result;
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.EXTENDED_KEY_USAGE, Arrays.toString(this.getExtendedKeyUsageDescriptions().toArray()));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ISCGEKU;
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        if (Context.CERTIFICATE.equals((Object)this.context)) {
            return this.buildXmlMessage(MessageTag.BBB_XCV_ISCGEKU_ANS_CERT, new Object[0]);
        }
        return this.buildXmlMessage(MessageTag.BBB_XCV_ISCGEKU_ANS, new Object[]{ValidationProcessUtils.getSubContextPosition(this.context, this.subContext)});
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CHAIN_CONSTRAINTS_FAILURE;
    }
}

