/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.aov.checks.AlgorithmObsolescenceValidationCheckWithId;
import java.util.Date;

public class CertificateAlgorithmObsolescenceValidationCheck<T extends XmlConstraintsConclusion>
extends AlgorithmObsolescenceValidationCheckWithId<T> {
    public CertificateAlgorithmObsolescenceValidationCheck(I18nProvider i18nProvider, T result, XmlAOV aovResult, Date validationDate, MessageTag position, String certificateId) {
        super(i18nProvider, result, aovResult, validationDate, position, certificateId);
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.AOV_XCV;
    }

    @Override
    protected boolean process() {
        XmlCryptographicValidation cryptographicValidation = this.getCertificateCryptographicValidation();
        return cryptographicValidation != null && this.isValidConclusion(cryptographicValidation.getConclusion());
    }

    private XmlCryptographicValidation getCertificateCryptographicValidation() {
        if (this.aovResult != null && this.aovResult.getCertificateChainCryptographicValidation() != null && Utils.isCollectionNotEmpty(this.aovResult.getCertificateChainCryptographicValidation().getCertificateCryptographicValidation())) {
            for (XmlCryptographicValidation cryptographicValidation : this.aovResult.getCertificateChainCryptographicValidation().getCertificateCryptographicValidation()) {
                if (!this.tokenId.equals(cryptographicValidation.getTokenId())) continue;
                return cryptographicValidation;
            }
        }
        return null;
    }
}

