/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.AbstractAlgorithmCryptographicChecker;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.DigestAlgorithmAtValidationTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.DigestAlgorithmReliableCheck;
import java.util.Date;

public class DigestAlgorithmCryptographicChecker
extends AbstractAlgorithmCryptographicChecker {
    private final DigestAlgorithm digestAlgorithm;

    public DigestAlgorithmCryptographicChecker(I18nProvider i18nProvider, DigestAlgorithm digestAlgorithm, Date validationDate, MessageTag position, CryptographicSuite constraint) {
        super(i18nProvider, validationDate, position, constraint);
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCC> item = this.firstItem = this.digestAlgorithmReliable();
        item = item.setNextItem(this.digestAlgorithmOnValidationTime());
    }

    protected ChainItem<XmlCC> digestAlgorithmReliable() {
        return new DigestAlgorithmReliableCheck(this.i18nProvider, this.digestAlgorithm, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    protected ChainItem<XmlCC> digestAlgorithmOnValidationTime() {
        return new DigestAlgorithmAtValidationTimeCheck(this.i18nProvider, this.digestAlgorithm, this.validationDate, (XmlCC)this.result, this.position, this.cryptographicSuite);
    }

    @Override
    protected XmlCryptographicAlgorithm getAlgorithm() {
        if (this.cryptographicAlgorithm == null) {
            this.cryptographicAlgorithm = new XmlCryptographicAlgorithm();
            if (this.digestAlgorithm != null) {
                this.cryptographicAlgorithm.setName(this.digestAlgorithm.getName());
                this.cryptographicAlgorithm.setUri(this.getDigestAlgorithmUri(this.digestAlgorithm));
            } else {
                this.cryptographicAlgorithm.setName("UNIDENTIFIED");
                this.cryptographicAlgorithm.setUri("urn:etsi:019102:algorithm:unidentified");
            }
        }
        return this.cryptographicAlgorithm;
    }

    private String getDigestAlgorithmUri(DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm != null) {
            if (digestAlgorithm.getUri() != null) {
                return digestAlgorithm.getUri();
            }
            if (digestAlgorithm.getOid() != null) {
                return digestAlgorithm.getOid();
            }
        }
        return "urn:etsi:019102:algorithm:unidentified";
    }

    @Override
    protected Date getNotAfter() {
        if (CryptographicSuiteUtils.isDigestAlgorithmReliable(this.cryptographicSuite, this.digestAlgorithm)) {
            return CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, this.digestAlgorithm);
        }
        return null;
    }
}

