/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.certificate.qwac;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificate;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlQWACProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.QWACProfile;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.executor.certificate.DetailedReportForCertificateBuilder;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationBlock;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.CertificateQualificationForQWACBlock;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.QWACForTLSCertificateValidationBlock;
import eu.europa.esig.dss.validation.process.qualification.signature.qwac.TLSBindingSignatureQualificationBlock;
import eu.europa.esig.dss.validation.process.vpfbs.BasicSignatureValidationProcess;
import eu.europa.esig.dss.validation.reports.DSSReportException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class DetailedReportForQWACBuilder
extends DetailedReportForCertificateBuilder {
    public DetailedReportForQWACBuilder(I18nProvider i18nProvider, DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime, String certificateId) {
        super(i18nProvider, diagnosticData, policy, currentTime, certificateId);
    }

    @Override
    protected Map<String, XmlBasicBuildingBlocks> executeAllBasicBuildingBlocks() {
        Map<String, XmlBasicBuildingBlocks> bbbs = super.executeAllBasicBuildingBlocks();
        this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
        return bbbs;
    }

    @Override
    protected void executeValidation(XmlDetailedReport detailedReport, Map<String, XmlBasicBuildingBlocks> bbbs) {
        XmlSignature xmlSignature = this.buildXmlTLSCertificateBindingSignature(detailedReport, bbbs);
        this.buildXmlCertificate(detailedReport, bbbs, xmlSignature);
    }

    protected XmlSignature buildXmlTLSCertificateBindingSignature(XmlDetailedReport detailedReport, Map<String, XmlBasicBuildingBlocks> bbbs) {
        SignatureWrapper bindingSignature = this.diagnosticData.getTLSCertificateBindingSignature();
        if (bindingSignature == null) {
            return null;
        }
        XmlSignature xmlSignature = new XmlSignature();
        xmlSignature.setId(bindingSignature.getId());
        XmlValidationProcessBasicSignature validation = this.executeBasicValidation(xmlSignature, bindingSignature, bbbs);
        if (this.policy.isEIDASConstraintPresent()) {
            TLSBindingSignatureQualificationBlock qualificationBlock = new TLSBindingSignatureQualificationBlock(this.i18nProvider, bbbs, validation, bindingSignature, detailedReport.getTLAnalysis(), this.diagnosticData.getWebsiteUrl());
            xmlSignature.setValidationSignatureQualification((XmlValidationSignatureQualification)qualificationBlock.execute());
        }
        XmlConclusion conclusion = validation.getConclusion();
        conclusion.setIndication(this.getSignatureFinalIndication(conclusion.getIndication()));
        xmlSignature.setConclusion(conclusion);
        detailedReport.getSignatureOrTimestampOrEvidenceRecord().add(xmlSignature);
        return xmlSignature;
    }

    private XmlValidationProcessBasicSignature executeBasicValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        BasicSignatureValidationProcess vpfbs = new BasicSignatureValidationProcess(this.i18nProvider, this.diagnosticData, signature, Collections.emptyList(), bbbs);
        XmlValidationProcessBasicSignature bs = (XmlValidationProcessBasicSignature)vpfbs.execute();
        signatureAnalysis.setValidationProcessBasicSignature(bs);
        return bs;
    }

    protected XmlCertificate buildXmlCertificate(XmlDetailedReport detailedReport, Map<String, XmlBasicBuildingBlocks> bbbs, XmlSignature bindingSignature) {
        XmlCertificate xmlCertificate = super.buildXmlCertificate(detailedReport, bbbs);
        QWACForTLSCertificateValidationBlock qwacForTLSCertificateValidationBlock = new QWACForTLSCertificateValidationBlock(this.i18nProvider, this.diagnosticData, this.getCertificate(), bbbs, xmlCertificate.getCertificateQualificationProcess(), this.getQWACProfile(bindingSignature), this.diagnosticData.getWebsiteUrl());
        XmlQWACProcess xmlQWACProcess = (XmlQWACProcess)qwacForTLSCertificateValidationBlock.execute();
        xmlCertificate.setQWACProcess(xmlQWACProcess);
        return xmlCertificate;
    }

    @Override
    protected CertificateQualificationBlock getCertificateQualificationBlock(XmlDetailedReport detailedReport, XmlBasicBuildingBlocks basicBuildingBlocks) {
        return new CertificateQualificationForQWACBlock(this.i18nProvider, basicBuildingBlocks.getConclusion(), this.currentTime, this.getCertificate(), detailedReport.getTLAnalysis());
    }

    private QWACProfile getQWACProfile(XmlSignature bindingSignature) {
        XmlQWACProcess qwacProcess;
        if (bindingSignature != null && bindingSignature.getValidationSignatureQualification() != null && (qwacProcess = bindingSignature.getValidationSignatureQualification().getQWACProcess()) != null) {
            return qwacProcess.getQWACType();
        }
        return QWACProfile.NOT_QWAC;
    }

    private Indication getSignatureFinalIndication(Indication highestIndication) {
        switch (highestIndication) {
            case PASSED: {
                return Indication.TOTAL_PASSED;
            }
            case INDETERMINATE: {
                return Indication.INDETERMINATE;
            }
            case FAILED: {
                return Indication.TOTAL_FAILED;
            }
        }
        throw new DSSReportException(String.format("The Indication '%s' is not supported!", highestIndication));
    }
}

