/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.token.DSSPrivateKeyAccessEntry;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class KSPrivateKeyEntry
implements DSSPrivateKeyAccessEntry {
    private final String alias;
    private final CertificateToken certificate;
    private final CertificateToken[] certificateChain;
    private final PrivateKey privateKey;

    public KSPrivateKeyEntry(String alias, KeyStore.PrivateKeyEntry privateKeyEntry) {
        Certificate[] simpleCertificateChain;
        this.alias = alias;
        this.certificate = new CertificateToken((X509Certificate)privateKeyEntry.getCertificate());
        ArrayList<CertificateToken> x509CertificateList = new ArrayList<CertificateToken>();
        for (Certificate currentCertificate : simpleCertificateChain = privateKeyEntry.getCertificateChain()) {
            x509CertificateList.add(new CertificateToken((X509Certificate)currentCertificate));
        }
        CertificateToken[] certificateChainArray = new CertificateToken[x509CertificateList.size()];
        this.certificateChain = x509CertificateList.toArray(certificateChainArray);
        this.privateKey = privateKeyEntry.getPrivateKey();
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public CertificateToken getCertificate() {
        return this.certificate;
    }

    @Override
    public CertificateToken[] getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return EncryptionAlgorithm.forKey(this.certificate.getPublicKey());
    }
}

