/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task.report;

import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.standalone.service.FOPService;
import eu.europa.esig.dss.standalone.task.report.GenerateReportTask;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateSimpleReportTask
extends GenerateReportTask {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateSimpleReportTask.class);
    private final XmlSimpleReport simpleReport;

    public GenerateSimpleReportTask(XmlSimpleReport simpleReport) {
        Objects.requireNonNull(simpleReport, "Simple Report cannot be null!");
        this.simpleReport = simpleReport;
    }

    @Override
    protected DSSDocument call() {
        InMemoryDocument inMemoryDocument;
        LOG.debug("Generating Simple Report...");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FOPService.getInstance().generateSimpleReport(this.simpleReport, baos);
            inMemoryDocument = new InMemoryDocument(baos.toByteArray(), "Simple Report.pdf", (MimeType)MimeTypeEnum.PDF);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.throwException("Unable to generate Simple Report", e);
                return null;
            }
        }
        baos.close();
        return inMemoryDocument;
    }
}

