/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.security;

import eu.europa.esig.dss.spi.security.DSSSecurityFactory;
import java.security.Provider;
import java.security.PublicKey;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class DSSContentVerifierProviderSecurityFactory
extends DSSSecurityFactory<PublicKey, ContentVerifierProvider> {
    public static final DSSContentVerifierProviderSecurityFactory INSTANCE = new DSSContentVerifierProviderSecurityFactory();

    private DSSContentVerifierProviderSecurityFactory() {
    }

    @Override
    protected String getFactoryClassName() {
        return ContentVerifierProvider.class.getSimpleName();
    }

    @Override
    protected String toString(PublicKey input) {
        return String.format("PublicKey with algorithm '%s'", input != null ? input.getAlgorithm() : null);
    }

    @Override
    protected ContentVerifierProvider buildWithProvider(PublicKey input, Provider securityProvider) throws OperatorCreationException {
        JcaContentVerifierProviderBuilder jcaContentVerifierProviderBuilder = new JcaContentVerifierProviderBuilder();
        jcaContentVerifierProviderBuilder.setProvider(securityProvider);
        return jcaContentVerifierProviderBuilder.build(input);
    }
}

