/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public class DSSMessageDigestCalculator {
    private final Map<DigestAlgorithm, MessageDigest> messageDigestMap;

    public DSSMessageDigestCalculator(DigestAlgorithm digestAlgorithm) {
        this(Collections.singletonList(digestAlgorithm));
    }

    public DSSMessageDigestCalculator(Collection<DigestAlgorithm> digestAlgorithms) {
        this.messageDigestMap = this.toMessageDigestMap(digestAlgorithms);
    }

    private Map<DigestAlgorithm, MessageDigest> toMessageDigestMap(Collection<DigestAlgorithm> digestAlgorithms) {
        Objects.requireNonNull(digestAlgorithms, "DigestAlgorithms shall be defined!");
        if (Utils.isCollectionEmpty(digestAlgorithms)) {
            throw new IllegalArgumentException("DigestAlgorithms collection cannot be empty!");
        }
        EnumMap<DigestAlgorithm, MessageDigest> messageDigestList = new EnumMap<DigestAlgorithm, MessageDigest>(DigestAlgorithm.class);
        for (DigestAlgorithm digestAlgorithm : digestAlgorithms) {
            Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
            messageDigestList.put(digestAlgorithm, this.toMessageDigest(digestAlgorithm));
        }
        return messageDigestList;
    }

    private MessageDigest toMessageDigest(DigestAlgorithm digestAlgorithm) {
        try {
            return digestAlgorithm.getMessageDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new DSSException(String.format("Unable to build MessageDigest for the algorithm '%s' : %s", digestAlgorithm.getName(), e.getMessage()), e);
        }
    }

    public void update(byte byteToAdd) {
        for (MessageDigest md : this.getMessageDigests()) {
            md.update(byteToAdd);
        }
    }

    public void update(byte[] bytes) {
        if (bytes != null) {
            for (MessageDigest md : this.getMessageDigests()) {
                md.update(bytes);
            }
        }
    }

    public void update(byte[] bytes, int offset, int length) {
        if (bytes != null) {
            for (MessageDigest md : this.getMessageDigests()) {
                md.update(bytes, offset, length);
            }
        }
    }

    private Collection<MessageDigest> getMessageDigests() {
        return this.messageDigestMap.values();
    }

    public void update(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        try (InputStream is = inputStream;){
            int count;
            byte[] buffer = new byte[4096];
            while ((count = is.read(buffer)) >= 0) {
                this.update(buffer, 0, count);
            }
        }
    }

    public DSSMessageDigest getMessageDigest(DigestAlgorithm digestAlgorithm) {
        MessageDigest messageDigest = this.messageDigestMap.get(digestAlgorithm);
        if (messageDigest == null) {
            throw new IllegalArgumentException("The DigestAlgorithm was not used on message-digest computation!");
        }
        return new DSSMessageDigest(digestAlgorithm, messageDigest.digest());
    }

    public OutputStream getOutputStream() {
        return this.getOutputStream(Utils.nullOutputStream());
    }

    public OutputStream getOutputStream(final OutputStream outputStream) {
        return new OutputStream(this){
            private final OutputStream wrappedOS;
            final /* synthetic */ DSSMessageDigestCalculator this$0;
            {
                this.this$0 = this$0;
                this.wrappedOS = outputStream;
            }

            @Override
            public void write(int b) throws IOException {
                this.wrappedOS.write(b);
                this.this$0.update((byte)b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.wrappedOS.write(b);
                this.this$0.update(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.wrappedOS.write(b, off, len);
                this.this$0.update(b, off, len);
            }

            @Override
            public void close() throws IOException {
                this.wrappedOS.close();
                super.close();
            }
        };
    }
}

