/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.http.commons;

import eu.europa.esig.dss.model.http.ResponseEnvelope;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.utils.Utils;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SSLCertificateLoader
implements Serializable {
    private static final long serialVersionUID = -2560386894555266018L;
    private static final Logger LOG = LoggerFactory.getLogger(SSLCertificateLoader.class);
    private CommonsDataLoader commonsDataLoader;

    @Deprecated
    public SSLCertificateLoader() {
    }

    public void setCommonsDataLoader(CommonsDataLoader commonsDataLoader) {
        this.commonsDataLoader = commonsDataLoader;
    }

    protected CommonsDataLoader getCommonsDataLoader() {
        if (this.commonsDataLoader == null) {
            this.commonsDataLoader = new CommonsDataLoader();
        }
        return this.commonsDataLoader;
    }

    @Deprecated
    public List<CertificateToken> getCertificates(String urlString) {
        String trimmedUrl = Utils.trim(urlString);
        if (Protocol.isHttpUrl(trimmedUrl)) {
            ResponseEnvelope responseEnvelope = this.getCommonsDataLoader().requestGet(trimmedUrl, true, false);
            Certificate[] tlsCertificates = responseEnvelope.getTLSCertificates();
            return this.toCertificateTokens(tlsCertificates);
        }
        throw new UnsupportedOperationException(String.format("DSS framework supports only HTTP(S) certificate extraction. Obtained URL : '%s'", urlString));
    }

    protected List<CertificateToken> toCertificateTokens(Certificate[] certificates) {
        ArrayList<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();
        for (Certificate certificate : certificates) {
            try {
                certificateTokens.add(DSSUtils.loadCertificate(certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                LOG.warn("Cannot read and/or create an instance of a CertificateToken for a certificate : '{}'. The entry is skipped. Reason : {}", (Object)certificate, (Object)e.getMessage());
            }
        }
        return certificateTokens;
    }
}

