/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineB;
import eu.europa.esig.dss.cades.signature.CMSForCAdESBuilderHelper;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineB;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import org.bouncycastle.operator.ContentSigner;

public class CMSForPAdESBuilderHelper
extends CMSForCAdESBuilderHelper {
    private final DSSMessageDigest messageDigest;

    public CMSForPAdESBuilderHelper(DSSMessageDigest messageDigest, PAdESSignatureParameters signatureParameters, ContentSigner contentSigner) {
        super(DSSUtils.toDigestDocument(messageDigest), signatureParameters, contentSigner);
        this.messageDigest = messageDigest;
    }

    @Override
    public CMSForPAdESBuilderHelper setOriginalCMS(CMS originalCMS) {
        return (CMSForPAdESBuilderHelper)super.setOriginalCMS(originalCMS);
    }

    @Override
    public CMSForPAdESBuilderHelper setTrustedCertificateSource(CertificateSource trustedCertificateSource) {
        return (CMSForPAdESBuilderHelper)super.setTrustedCertificateSource(trustedCertificateSource);
    }

    @Override
    public CMSForPAdESBuilderHelper setIncludeUnsignedAttributes(boolean includeUnsignedAttributes) {
        return (CMSForPAdESBuilderHelper)super.setIncludeUnsignedAttributes(includeUnsignedAttributes);
    }

    @Override
    protected CAdESLevelBaselineB initCAdESProfile() {
        return new PAdESLevelBaselineB(this.messageDigest);
    }

    @Override
    protected boolean isEncapsulateSignerData() {
        return false;
    }
}

