/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.tsl;

import eu.europa.esig.dss.model.timedependent.BaseTimeDependent;
import java.util.Date;
import java.util.Objects;

public class CertificateTrustTime
extends BaseTimeDependent {
    private static final long serialVersionUID = -5006781640706750658L;
    private final boolean trusted;

    public CertificateTrustTime(boolean trusted) {
        this.trusted = trusted;
    }

    public CertificateTrustTime(Date startDate, Date endDate) {
        super(startDate, endDate);
        this.trusted = true;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean isTrustedAtTime(Date controlTime) {
        return this.isTrusted() && Objects.equals(this.getDateBefore(this.getStartDate(), controlTime), this.getStartDate()) && Objects.equals(this.getDateAfter(this.getEndDate(), controlTime), this.getEndDate());
    }

    public CertificateTrustTime getJointTrustTime(Date startDate, Date endDate) {
        return new CertificateTrustTime(this.getDateBefore(this.getStartDate(), startDate), this.getDateAfter(this.getEndDate(), endDate));
    }

    private Date getDateBefore(Date dateOne, Date dateTwo) {
        if (dateOne == null) {
            return dateOne;
        }
        if (dateTwo == null) {
            return dateTwo;
        }
        if (dateOne.before(dateTwo)) {
            return dateOne;
        }
        return dateTwo;
    }

    private Date getDateAfter(Date dateOne, Date dateTwo) {
        if (dateOne == null) {
            return dateOne;
        }
        if (dateTwo == null) {
            return dateTwo;
        }
        if (dateOne.after(dateTwo)) {
            return dateOne;
        }
        return dateTwo;
    }

    @Override
    public String toString() {
        return "CertificateTrustTime [trusted=" + this.trusted + "] " + super.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CertificateTrustTime that = (CertificateTrustTime)object;
        return this.trusted == that.trusted;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.trusted);
        return result;
    }
}

