/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.identifier;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.identifier.IdentifierBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;

public class EntityIdentifierBuilder
implements IdentifierBuilder {
    private final PublicKey publicKey;
    private final X500Principal subjectName;

    public EntityIdentifierBuilder(PublicKey publicKey, X500Principal subjectName) {
        this.publicKey = publicKey;
        this.subjectName = subjectName;
    }

    @Override
    public EntityIdentifier build() {
        return new EntityIdentifier(this.buildBinaries());
    }

    protected byte[] buildBinaries() {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.publicKey != null) {
                baos.write(this.publicKey.getEncoded());
            }
            if (this.subjectName != null) {
                baos.write(this.subjectName.getEncoded());
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred while building an Identifier : %s", e.getMessage()), e);
            }
        }
        baos.close();
        return byArray;
    }
}

