/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.identifier;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.identifier.Identifier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class DataIdentifier
extends Identifier {
    private static final long serialVersionUID = -9023635708755646223L;

    public DataIdentifier(byte[] data) {
        super("D-", data);
    }

    public DataIdentifier(String name, DSSDocument document) {
        this(DataIdentifier.build(name, document));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] build(String name, DSSDocument document) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                Digest dataDigest;
                if (name != null) {
                    dos.writeChars(name);
                }
                if ((dataDigest = DataIdentifier.getDigest(document)) != null) {
                    dos.write(dataDigest.getValue());
                }
                dos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to build a JAdESAttributeIdentifier. Reason : %s", e.getMessage()), e);
        }
    }

    private static Digest getDigest(DSSDocument document) {
        if (document != null) {
            if (document instanceof DigestDocument) {
                return ((DigestDocument)document).getExistingDigest();
            }
            return new Digest(DIGEST_ALGO, document.getDigestValue(DIGEST_ALGO));
        }
        return null;
    }
}

