/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.signature.JAdESBuilder;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineB;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJAdESBuilder
implements JAdESBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJAdESBuilder.class);
    protected final JAdESSignatureParameters parameters;
    protected final JAdESLevelBaselineB jadesLevelBaselineB;

    protected AbstractJAdESBuilder(CertificateVerifier certificateVerifier, JAdESSignatureParameters parameters, List<DSSDocument> documentsToSign) {
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier must be defined!");
        Objects.requireNonNull(parameters, "SignatureParameters must be defined!");
        if (Utils.isCollectionEmpty(documentsToSign)) {
            throw new IllegalArgumentException("Documents to sign must be provided!");
        }
        this.parameters = parameters;
        this.jadesLevelBaselineB = new JAdESLevelBaselineB(certificateVerifier, parameters, documentsToSign);
    }

    @Override
    public ToBeSigned buildDataToBeSigned() {
        this.assertConfigurationValidity(this.parameters);
        JWS jws = new JWS();
        this.incorporateHeader(jws);
        this.incorporatePayload(jws);
        byte[] dataToSign = DSSJsonUtils.getSigningInputBytes(jws);
        return new ToBeSigned(dataToSign);
    }

    protected void incorporateHeader(JWS jws) {
        Map<String, Object> signedProperties = this.jadesLevelBaselineB.getSignedProperties();
        for (Map.Entry<String, Object> signedHeader : signedProperties.entrySet()) {
            jws.setHeader(signedHeader.getKey(), signedHeader.getValue());
        }
    }

    protected void incorporatePayload(JWS jws) {
        byte[] payloadBytes = this.jadesLevelBaselineB.getPayloadBytes();
        if (Utils.isArrayNotEmpty(payloadBytes)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("The payload of created signature -> {}", (Object)new String(payloadBytes));
                LOG.trace("The base64 payload of created signature -> {}", (Object)Utils.toBase64(payloadBytes));
            }
            jws.setPayloadOctets(payloadBytes);
        }
    }

    protected abstract void assertConfigurationValidity(JAdESSignatureParameters var1);
}

