/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.xml.digest;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.evidencerecord.common.digest.AbstractEvidenceRecordRenewalDigestBuilder;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.xml.digest.XMLEvidenceRecordDataObjectDigestBuilder;
import eu.europa.esig.dss.evidencerecord.xml.digest.XMLEvidenceRecordRenewalDigestBuilderHelper;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlEvidenceRecord;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLEvidenceRecordRenewalDigestBuilder
extends AbstractEvidenceRecordRenewalDigestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XMLEvidenceRecordRenewalDigestBuilder.class);
    private String canonicalizationMethod;

    public XMLEvidenceRecordRenewalDigestBuilder(DSSDocument document) {
        this(new XmlEvidenceRecord(document));
    }

    public XMLEvidenceRecordRenewalDigestBuilder(DSSDocument document, DigestAlgorithm digestAlgorithm) {
        this(new XmlEvidenceRecord(document), digestAlgorithm);
    }

    public XMLEvidenceRecordRenewalDigestBuilder(XmlEvidenceRecord xmlEvidenceRecord) {
        super(xmlEvidenceRecord);
    }

    public XMLEvidenceRecordRenewalDigestBuilder(XmlEvidenceRecord xmlEvidenceRecord, DigestAlgorithm digestAlgorithm) {
        super(xmlEvidenceRecord, digestAlgorithm);
    }

    public XMLEvidenceRecordRenewalDigestBuilder setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
        return this;
    }

    @Override
    public XMLEvidenceRecordRenewalDigestBuilder setDetachedContent(List<DSSDocument> detachedContent) {
        return (XMLEvidenceRecordRenewalDigestBuilder)super.setDetachedContent(detachedContent);
    }

    @Override
    public DSSMessageDigest buildTimeStampRenewalDigest() {
        if (this.digestAlgorithm != null) {
            LOG.info("Provided DigestAlgorithm is ignored on hash computation. The digest algorithm from the last ArchiveTimeStampChain will be used.");
        }
        if (this.canonicalizationMethod != null) {
            LOG.info("Provided canonicalization method is ignored on hash computation. The canonicalization algorithm from the last ArchiveTimeStampChain will be used.");
        }
        ArchiveTimeStampObject archiveTimeStamp = this.getLastArchiveTimeStampObject();
        return this.getArchiveTimeStampSequenceDigestHelper().buildTimeStampRenewalDigest(archiveTimeStamp);
    }

    @Override
    public List<Digest> buildHashTreeRenewalDigestGroup() {
        ArrayList<Digest> result = new ArrayList<Digest>();
        DigestAlgorithm digestAlgorithm = this.getDigestAlgorithmOrDefault();
        XmlArchiveTimeStampChainObject lastArchiveTimeStampChainObject = (XmlArchiveTimeStampChainObject)this.getLastArchiveTimeStampChainObject();
        DSSMessageDigest archiveTimeStampSequenceDigest = this.getArchiveTimeStampSequenceDigestHelper().buildArchiveTimeStampSequenceDigest(digestAlgorithm, this.canonicalizationMethod, lastArchiveTimeStampChainObject.getOrder() + 1);
        result.add(archiveTimeStampSequenceDigest);
        if (Utils.isCollectionNotEmpty(this.detachedContent)) {
            for (DSSDocument detachedDocument : this.detachedContent) {
                Digest dataObjectDigest = new XMLEvidenceRecordDataObjectDigestBuilder(detachedDocument, digestAlgorithm).setCanonicalizationMethod(this.canonicalizationMethod).build();
                result.add(dataObjectDigest);
            }
        } else {
            LOG.info("No detached content have been provided. Computation of digest for data object has been skipped.");
        }
        return result;
    }

    protected XMLEvidenceRecordRenewalDigestBuilderHelper getArchiveTimeStampSequenceDigestHelper() {
        return new XMLEvidenceRecordRenewalDigestBuilderHelper((XmlEvidenceRecord)this.evidenceRecord);
    }
}

