/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.xml.digest;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.evidencerecord.common.digest.AbstractDataObjectDigestBuilder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.dss.xml.utils.XMLCanonicalizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class XMLEvidenceRecordDataObjectDigestBuilder
extends AbstractDataObjectDigestBuilder {
    private String canonicalizationMethod;

    public XMLEvidenceRecordDataObjectDigestBuilder(byte[] binaries) {
        this(binaries, DigestAlgorithm.SHA256);
    }

    public XMLEvidenceRecordDataObjectDigestBuilder(InputStream inputStream) {
        this(inputStream, DigestAlgorithm.SHA256);
    }

    public XMLEvidenceRecordDataObjectDigestBuilder(DSSDocument document) {
        this(document, DigestAlgorithm.SHA256);
    }

    public XMLEvidenceRecordDataObjectDigestBuilder(byte[] binaries, DigestAlgorithm digestAlgorithm) {
        super(binaries, digestAlgorithm);
    }

    public XMLEvidenceRecordDataObjectDigestBuilder(InputStream inputStream, DigestAlgorithm digestAlgorithm) {
        super(inputStream, digestAlgorithm);
    }

    public XMLEvidenceRecordDataObjectDigestBuilder(DSSDocument document, DigestAlgorithm digestAlgorithm) {
        super(document, digestAlgorithm);
    }

    public XMLEvidenceRecordDataObjectDigestBuilder setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
        return this;
    }

    @Override
    public Digest build() {
        DSSDocument providedDocument = this.document;
        if (this.inputStream != null) {
            providedDocument = new InMemoryDocument(this.inputStream);
        }
        if (providedDocument == null) {
            throw new IllegalStateException("DSSDocument or InputStream shall be defined!");
        }
        byte[] hashValue = DomUtils.isDOM(providedDocument) ? this.getDigestValueOnCanonicalizedDocument(providedDocument) : providedDocument.getDigestValue(this.digestAlgorithm);
        return new Digest(this.digestAlgorithm, hashValue);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] getDigestValueOnCanonicalizedDocument(DSSDocument document) {
        DSSMessageDigestCalculator messageDigestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
        try (InputStream is = document.openStream();){
            byte[] byArray;
            block14: {
                OutputStream os = messageDigestCalculator.getOutputStream();
                try {
                    XMLCanonicalizer.createInstance(this.canonicalizationMethod).canonicalize(is, os);
                    byArray = messageDigestCalculator.getMessageDigest(this.digestAlgorithm).getValue();
                    if (os == null) break block14;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to read document with name '%s'! Reason : %s", document.getName(), e.getMessage()), e);
        }
    }
}

