/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation.identifier;

import eu.europa.esig.dss.evidencerecord.common.validation.identifier.EvidenceRecordIdentifierBuilder;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;

public class EmbeddedEvidenceRecordIdentifierBuilder
extends EvidenceRecordIdentifierBuilder {
    private static final String ORDER_OF_ATTRIBUTE_PREFIX = "-OOA-";
    private static final String ORDER_WITHIN_ATTRIBUTE_PREFIX = "-OWA-";
    private final EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper;

    public EmbeddedEvidenceRecordIdentifierBuilder(EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper) {
        this.embeddedEvidenceRecordHelper = embeddedEvidenceRecordHelper;
    }

    @Override
    protected String getEvidenceRecordPosition() {
        StringBuilder sb = new StringBuilder();
        if (this.embeddedEvidenceRecordHelper.getMasterSignature() != null) {
            sb.append(this.embeddedEvidenceRecordHelper.getMasterSignature().getId());
        }
        if (this.embeddedEvidenceRecordHelper.getEvidenceRecordAttribute() != null) {
            sb.append(this.embeddedEvidenceRecordHelper.getEvidenceRecordAttribute().getIdentifier().asXmlId());
        }
        if (this.embeddedEvidenceRecordHelper.getOrderOfAttribute() != null) {
            sb.append(ORDER_OF_ATTRIBUTE_PREFIX);
            sb.append(this.embeddedEvidenceRecordHelper.getOrderOfAttribute());
        }
        if (this.embeddedEvidenceRecordHelper.getOrderWithinAttribute() != null) {
            sb.append(ORDER_WITHIN_ATTRIBUTE_PREFIX);
            sb.append(this.embeddedEvidenceRecordHelper.getOrderWithinAttribute());
        }
        return sb.toString();
    }
}

