/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.asn1.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1SequenceObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordParser;
import eu.europa.esig.dss.evidencerecord.common.validation.timestamp.EvidenceRecordTimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.x509.tsp.TimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import org.bouncycastle.asn1.tsp.ArchiveTimeStampChain;
import org.bouncycastle.asn1.tsp.ArchiveTimeStampSequence;
import org.bouncycastle.asn1.tsp.EvidenceRecord;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1EvidenceRecordParser
implements EvidenceRecordParser {
    private static final Logger LOG = LoggerFactory.getLogger(ASN1EvidenceRecordParser.class);
    private final EvidenceRecord evidenceRecord;
    private String filename;
    private EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper;

    public ASN1EvidenceRecordParser(EvidenceRecord evidenceRecord) {
        this.evidenceRecord = evidenceRecord;
    }

    public ASN1EvidenceRecordParser setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public ASN1EvidenceRecordParser setEmbeddedEvidenceRecordHelper(EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper) {
        this.embeddedEvidenceRecordHelper = embeddedEvidenceRecordHelper;
        return this;
    }

    public List<ASN1ArchiveTimeStampChainObject> parse() {
        ArchiveTimeStampSequence archiveTimeStampSequenceList = this.evidenceRecord.getArchiveTimeStampSequence();
        if (archiveTimeStampSequenceList != null && archiveTimeStampSequenceList.size() > 0) {
            ASN1ArchiveTimeStampChainObject[] result = new ASN1ArchiveTimeStampChainObject[archiveTimeStampSequenceList.size()];
            for (int i = 0; i < archiveTimeStampSequenceList.size(); ++i) {
                ASN1ArchiveTimeStampChainObject archiveTimeStampChainObject;
                ArchiveTimeStampChain archiveTimeStampChain = archiveTimeStampSequenceList.getArchiveTimeStampChains()[i];
                result[i] = archiveTimeStampChainObject = this.getASN1ArchiveTimeStampChainObject(archiveTimeStampChain, i + 1);
            }
            return Arrays.asList(result);
        }
        return Collections.emptyList();
    }

    private ASN1ArchiveTimeStampChainObject getASN1ArchiveTimeStampChainObject(ArchiveTimeStampChain archiveTimeStampChain, int order) {
        ASN1ArchiveTimeStampChainObject archiveTimeStampChainObject = new ASN1ArchiveTimeStampChainObject();
        archiveTimeStampChainObject.setDigestAlgorithm(this.getDigestAlgorithm(archiveTimeStampChain));
        archiveTimeStampChainObject.setOrder(order);
        archiveTimeStampChainObject.setArchiveTimeStamps(this.getASN1ArchiveTimeStamps(archiveTimeStampChain, order));
        return archiveTimeStampChainObject;
    }

    private DigestAlgorithm getDigestAlgorithm(ArchiveTimeStampChain archiveTimeStampChain) {
        return this.getDigestAlgorithm(archiveTimeStampChain.getArchiveTimestamps()[0]);
    }

    private List<? extends ArchiveTimeStampObject> getASN1ArchiveTimeStamps(ArchiveTimeStampChain archiveTimeStampChain, int archiveTimeStampChainOrder) {
        ArchiveTimeStamp[] archiveTimeStampList = archiveTimeStampChain.getArchiveTimestamps();
        if (archiveTimeStampList != null && archiveTimeStampList.length > 0) {
            ASN1ArchiveTimeStampObject[] result = new ASN1ArchiveTimeStampObject[archiveTimeStampList.length];
            for (int i = 0; i < archiveTimeStampList.length; ++i) {
                ASN1ArchiveTimeStampObject archiveTimeStampObject;
                ArchiveTimeStamp archiveTimeStamp = archiveTimeStampList[i];
                result[i] = archiveTimeStampObject = this.getASN1ArchiveTimeStampObject(archiveTimeStamp, archiveTimeStampChainOrder, i + 1);
            }
            return Arrays.asList(result);
        }
        return Collections.emptyList();
    }

    private ASN1ArchiveTimeStampObject getASN1ArchiveTimeStampObject(ArchiveTimeStamp archiveTimeStamp, int archiveTimeStampChainOrder, int archiveTimeStampOrder) {
        ASN1ArchiveTimeStampObject archiveTimeStampObject = new ASN1ArchiveTimeStampObject();
        archiveTimeStampObject.setHashTree(this.getHashTree(archiveTimeStamp));
        archiveTimeStampObject.setDigestAlgorithm(this.getDigestAlgorithm(archiveTimeStamp));
        archiveTimeStampObject.setTimestampToken(this.getTimestampToken(archiveTimeStamp, archiveTimeStampChainOrder, archiveTimeStampOrder));
        archiveTimeStampObject.setOrder(archiveTimeStampOrder);
        return archiveTimeStampObject;
    }

    private DigestAlgorithm getDigestAlgorithm(ArchiveTimeStamp archiveTimeStamp) {
        AlgorithmIdentifier algIdentifier = archiveTimeStamp.getDigestAlgorithmIdentifier();
        return DigestAlgorithm.forOID(algIdentifier.getAlgorithm().getId());
    }

    private TimestampToken getTimestampToken(ArchiveTimeStamp archiveTimeStamp, int archiveTimeStampChainOrder, int archieTimeStampOrder) {
        ContentInfo contentInfo = archiveTimeStamp.getTimeStamp();
        if (contentInfo == null) {
            throw new IllegalInputException("TimeStampToken shall be defined!");
        }
        try {
            byte[] timestampBinaries = contentInfo.getEncoded();
            EvidenceRecordTimestampIdentifierBuilder identifierBuilder = new EvidenceRecordTimestampIdentifierBuilder(timestampBinaries).setArchiveTimeStampChainOrder(archiveTimeStampChainOrder).setArchiveTimeStampOrder(archieTimeStampOrder).setFilename(this.filename);
            if (this.embeddedEvidenceRecordHelper != null) {
                identifierBuilder = identifierBuilder.setEvidenceRecordAttributeOrder(this.embeddedEvidenceRecordHelper.getOrderOfAttribute()).setEvidenceRecordWithinAttributeOrder(this.embeddedEvidenceRecordHelper.getOrderWithinAttribute());
            }
            return new TimestampToken(timestampBinaries, TimestampType.EVIDENCE_RECORD_TIMESTAMP, new ArrayList<TimestampedReference>(), (TimestampIdentifierBuilder)identifierBuilder);
        }
        catch (Exception e) {
            LOG.warn("Unable to create a time-stamp token. Reason : {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private List<ASN1SequenceObject> getHashTree(ArchiveTimeStamp archiveTimeStamp) {
        PartialHashtree[] hashTree = archiveTimeStamp.getReducedHashTree();
        if (hashTree != null && hashTree.length > 0) {
            ASN1SequenceObject[] result = new ASN1SequenceObject[hashTree.length];
            for (int i = 0; i < hashTree.length; ++i) {
                ASN1SequenceObject digestValueGroup;
                PartialHashtree partialHashtree = hashTree[i];
                result[i] = digestValueGroup = this.getDigestValueGroup(partialHashtree, i + 1);
            }
            return Arrays.asList(result);
        }
        return Collections.emptyList();
    }

    private ASN1SequenceObject getDigestValueGroup(PartialHashtree partialHashtree, int order) {
        ASN1SequenceObject digestValueGroup = new ASN1SequenceObject();
        digestValueGroup.setDigestValues(this.getDigestValues(partialHashtree));
        digestValueGroup.setOrder(order);
        return digestValueGroup;
    }

    private List<byte[]> getDigestValues(PartialHashtree partialHashtree) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        byte[][] digestValueList = partialHashtree.getValues();
        for (int i = 0; i < partialHashtree.getValueCount(); ++i) {
            byte[] digestValue = digestValueList[i];
            result.add(digestValue);
        }
        return result;
    }
}

