/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.security.DSSSignerInformationVerifierSecurityFactory;
import eu.europa.esig.dss.spi.x509.SignatureIntegrityValidator;
import java.security.PublicKey;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;

public class CAdESSignatureIntegrityValidator
extends SignatureIntegrityValidator {
    private final SignerInformation signerInformation;

    public CAdESSignatureIntegrityValidator(SignerInformation signerInformation) {
        this.signerInformation = signerInformation;
    }

    @Override
    protected boolean verify(PublicKey publicKey) throws DSSException {
        try {
            SignerInformationVerifier signerInformationVerifier = (SignerInformationVerifier)DSSSignerInformationVerifierSecurityFactory.PUBLIC_TOKEN_INSTANCE.build(publicKey);
            return this.signerInformation.verify(signerInformationVerifier);
        }
        catch (CMSSignerDigestMismatchException e) {
            throw new DSSException(String.format("Unable to validate CMS Signature : %s", e.getMessage()));
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to validate CMS Signature : %s", e.getMessage()), e);
        }
    }
}

