/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.spi.validation.SignatureProperties;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;

public abstract class CAdESSigProperties
implements SignatureProperties<CAdESAttribute> {
    private static final long serialVersionUID = -1730805576179343914L;
    private final ASN1Set asn1Set;

    CAdESSigProperties(ASN1Set asn1Set) {
        this.asn1Set = asn1Set;
    }

    @Override
    public boolean isExist() {
        return this.asn1Set != null;
    }

    @Override
    public List<CAdESAttribute> getAttributes() {
        ArrayList<CAdESAttribute> attributes = new ArrayList<CAdESAttribute>();
        if (this.isExist()) {
            for (int ii = 0; ii < this.asn1Set.size(); ++ii) {
                Attribute attribute = Attribute.getInstance(this.asn1Set.getObjectAt(ii));
                attributes.add(new CAdESAttribute(attribute, ii));
            }
        }
        return attributes;
    }
}

