/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.executor.CompleteValidationContextExecutor;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CAdESSignatureExtension
implements SignatureExtension<CAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignatureExtension.class);
    protected final TSPSource tspSource;
    protected final CertificateVerifier certificateVerifier;
    protected DSSResourcesHandlerBuilder resourcesHandlerBuilder;

    protected CAdESSignatureExtension(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(tspSource, "The TSPSource cannot be null");
        this.tspSource = tspSource;
        this.certificateVerifier = certificateVerifier;
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument signatureToExtend, CAdESSignatureParameters parameters) {
        LOG.trace("EXTEND SIGNATURES.");
        CMS cms = this.getCMS(signatureToExtend);
        CMS extendedCMS = this.extendCMSSignatures(cms, parameters);
        return CMSUtils.writeToDSSDocument(extendedCMS, this.resourcesHandlerBuilder);
    }

    private CMS getCMS(DSSDocument document) {
        return CMSUtils.parseToCMS(document);
    }

    public CMS extendCMSSignatures(CMS cms, CAdESSignatureParameters parameters) {
        return this.extendCMSSignatures(cms, cms.getSignerInfos().getSigners(), parameters);
    }

    public CMS extendCMSSignatures(CMS cms, SignerInformation signerInformation, CAdESSignatureParameters parameters) {
        return this.extendCMSSignatures(cms, Collections.singletonList(signerInformation), parameters);
    }

    protected CMS extendCMSSignatures(CMS cms, Collection<SignerInformation> signerInformationsToExtend, CAdESSignatureParameters parameters) {
        LOG.info("EXTEND CMS SIGNATURES.");
        Collection<SignerInformation> signerInformationCollection = cms.getSignerInfos().getSigners();
        if (Utils.isCollectionEmpty(signerInformationCollection)) {
            throw new IllegalInputException("Unable to extend the document! No signatures found.");
        }
        ArrayList<String> signatureIdsToExtend = new ArrayList<String>();
        CMSDocumentAnalyzer validator = this.getDocumentValidator(cms, parameters);
        List<AdvancedSignature> signatures = validator.getSignatures();
        for (AdvancedSignature signature : signatures) {
            CAdESSignature cadesSignature = (CAdESSignature)signature;
            if (!signerInformationsToExtend.contains(cadesSignature.getSignerInformation())) continue;
            signatureIdsToExtend.add(cadesSignature.getId());
        }
        return this.extendCMSSignatures(cms, parameters, signatureIdsToExtend);
    }

    protected abstract CMS extendCMSSignatures(CMS var1, CAdESSignatureParameters var2, List<String> var3);

    protected CMS replaceSigners(CMS originalCMS, List<SignerInformation> newSignerInformationList) {
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        CMS updatedCmsSignedData = CMSUtils.replaceSigners(originalCMS, newSignerStore);
        return CMSUtils.populateDigestAlgorithmSet(updatedCmsSignedData, originalCMS.getDigestAlgorithmIDs());
    }

    protected ASN1Object getTimeStampAttributeValue(DSSMessageDigest timestampMessageDigest, DigestAlgorithm timestampDigestAlgorithm, Attribute ... attributesForTimestampToken) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message to timestamp is {}", (Object)timestampMessageDigest);
        }
        TimestampBinary timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, timestampMessageDigest.getValue());
        CMS cms = CMSUtils.parseToCMS(timeStampToken.getBytes());
        if (attributesForTimestampToken != null) {
            SignerInformation signerInformation = cms.getSignerInfos().getSigners().iterator().next();
            AttributeTable unsignedAttributes = CAdESUtils.getUnsignedAttributes(signerInformation);
            for (Attribute attributeToAdd : attributesForTimestampToken) {
                ASN1ObjectIdentifier attrType = attributeToAdd.getAttrType();
                ASN1Encodable objectAt = attributeToAdd.getAttrValues().getObjectAt(0);
                unsignedAttributes = unsignedAttributes.add(attrType, objectAt);
            }
            if (unsignedAttributes.size() == 0) {
                unsignedAttributes = null;
            }
            SignerInformation newSignerInformation = CMSUtils.replaceUnsignedAttributes(signerInformation, unsignedAttributes);
            ArrayList<SignerInformation> signerInformationList = new ArrayList<SignerInformation>();
            signerInformationList.add(newSignerInformation);
            SignerInformationStore newSignerStore = new SignerInformationStore(signerInformationList);
            cms = CMSUtils.replaceSigners(cms, newSignerStore);
        }
        byte[] newTimeStampTokenBytes = cms.getDEREncoded();
        return DSSASN1Utils.toASN1Primitive(newTimeStampTokenBytes);
    }

    protected CMSDocumentAnalyzer getDocumentValidator(CMS cms, CAdESSignatureParameters parameters) {
        CMSDocumentAnalyzer documentValidator = new CMSDocumentAnalyzer(cms);
        documentValidator.setCertificateVerifier(this.certificateVerifier);
        documentValidator.setDetachedContents(parameters.getDetachedContents());
        documentValidator.setValidationContextExecutor(CompleteValidationContextExecutor.INSTANCE);
        return documentValidator;
    }
}

