/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.model.ContainerInfo;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.diagnostic.SignedDocumentDiagnosticDataBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ASiCContainerDiagnosticDataBuilder
extends SignedDocumentDiagnosticDataBuilder {
    private ContainerInfo containerInfo;

    public ASiCContainerDiagnosticDataBuilder containerInfo(ContainerInfo containerInfo) {
        this.containerInfo = containerInfo;
        return this;
    }

    @Override
    public XmlDiagnosticData build() {
        XmlDiagnosticData diagnosticData = super.build();
        diagnosticData.setContainerInfo(this.getXmlContainerInfo());
        return diagnosticData;
    }

    private XmlContainerInfo getXmlContainerInfo() {
        if (this.containerInfo != null) {
            XmlContainerInfo xmlContainerInfo = new XmlContainerInfo();
            xmlContainerInfo.setContainerType(this.containerInfo.getContainerType());
            String zipComment = this.containerInfo.getZipComment();
            if (Utils.isStringNotBlank(zipComment)) {
                xmlContainerInfo.setZipComment(zipComment);
            }
            xmlContainerInfo.setMimeTypeFilePresent(this.containerInfo.isMimeTypeFilePresent());
            xmlContainerInfo.setMimeTypeContent(this.containerInfo.getMimeTypeContent());
            xmlContainerInfo.setContentFiles(this.containerInfo.getSignedDocumentFilenames());
            xmlContainerInfo.setManifestFiles(this.getXmlManifests(this.containerInfo.getManifestFiles()));
            return xmlContainerInfo;
        }
        return null;
    }

    private List<XmlManifestFile> getXmlManifests(List<ManifestFile> manifestFiles) {
        if (Utils.isCollectionNotEmpty(manifestFiles)) {
            ArrayList<XmlManifestFile> xmlManifests = new ArrayList<XmlManifestFile>();
            for (ManifestFile manifestFile : manifestFiles) {
                XmlManifestFile xmlManifest = new XmlManifestFile();
                xmlManifest.setFilename(manifestFile.getFilename());
                xmlManifest.setSignatureFilename(manifestFile.getSignatureFilename());
                for (ManifestEntry entry : manifestFile.getEntries()) {
                    xmlManifest.getEntries().add(entry.getUri());
                }
                xmlManifests.add(xmlManifest);
            }
            return xmlManifests;
        }
        return Collections.emptyList();
    }
}

