/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.json;

import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.Schema;
import com.github.erosb.jsonsKema.SchemaClient;
import com.github.erosb.jsonsKema.SchemaLoader;
import com.github.erosb.jsonsKema.SchemaLoaderConfig;
import com.github.erosb.jsonsKema.ValidationFailure;
import com.github.erosb.jsonsKema.Validator;
import eu.europa.esig.json.JSONParser;
import eu.europa.esig.json.JsonObjectWrapper;
import eu.europa.esig.json.ValidationMessage;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSONSchemaAbstractUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JSONSchemaAbstractUtils.class);
    private static final String JSON_DRAFT_07_SCHEMA_LOCATION = "/schema/json-schema-draft-07.json";
    private static final String JSON_DRAFT_07_SCHEMA_URI = "http://json-schema.org/draft-07/schema#";
    private Validator validator;
    private Map<URI, String> definitions;

    protected JSONSchemaAbstractUtils() {
    }

    public List<String> validateAgainstSchema(InputStream is) {
        return this.validateAgainstSchema(new JSONParser().parse(is));
    }

    public List<String> validateAgainstSchema(String jsonString) {
        return this.validateAgainstSchema(new JSONParser().parse(jsonString));
    }

    public List<String> validateAgainstSchema(JsonObjectWrapper jsonObjectWrapper) {
        return this.validateAgainstSchema(jsonObjectWrapper.getJsonObject());
    }

    public List<String> validateAgainstSchema(JsonObject json) {
        Validator validator = this.getValidator();
        ValidationFailure validationFailure = validator.validate(json);
        if (validationFailure != null) {
            Set<ValidationFailure> causes = validationFailure.getCauses();
            if (causes != null && !causes.isEmpty()) {
                return causes.stream().map(v -> new ValidationMessage((ValidationFailure)v).getMessage()).collect(Collectors.toList());
            }
            String message = validationFailure.getMessage();
            if (message != null && validationFailure.getInstance() != null) {
                return Collections.singletonList(String.format("%s, location: %s", message, validationFailure.getInstance().getLocation()));
            }
            LOG.warn("Unknown validation failure '{}' format on JSON Schema validation : {}", (Object)validationFailure.getClass().getSimpleName(), (Object)validationFailure.toString());
            return Collections.singletonList(validationFailure.toString());
        }
        return Collections.emptyList();
    }

    protected Schema getSchema() {
        return this.loadSchema(this.getSchemaURI(), this.getSchemaDefinitions());
    }

    public abstract String getSchemaURI();

    public abstract Map<URI, String> getSchemaDefinitions();

    protected Validator getValidator() {
        if (this.validator == null) {
            this.validator = Validator.forSchema(this.getSchema());
        }
        return this.validator;
    }

    public Map<URI, String> getJSONSchemaDefinitions() {
        if (this.definitions == null) {
            this.definitions = new HashMap<URI, String>();
            this.definitions.put(URI.create(JSON_DRAFT_07_SCHEMA_URI), JSON_DRAFT_07_SCHEMA_LOCATION);
        }
        return this.definitions;
    }

    protected Schema loadSchema(String schemaJSON, Map<URI, String> definitions) {
        ResourceSchemaClient schemaClient = new ResourceSchemaClient(definitions);
        SchemaLoaderConfig schemaLoaderConfig = new SchemaLoaderConfig(schemaClient, URI.create(""));
        IJsonValue parsed = schemaClient.getParsed(URI.create(schemaJSON));
        return new SchemaLoader(parsed, schemaLoaderConfig).load();
    }

    private static class ResourceSchemaClient
    implements SchemaClient {
        private final Map<URI, String> resources;

        ResourceSchemaClient(Map<URI, String> resources) {
            this.resources = resources;
        }

        @Override
        @NotNull
        public InputStream get(@NotNull URI uri) {
            InputStream is;
            String schema = this.resources.get(uri);
            if (schema != null && (is = JSONSchemaAbstractUtils.class.getResourceAsStream(schema)) != null) {
                return is;
            }
            throw new IllegalStateException(String.format("Unable to load a schema for URI : %s", uri));
        }

        @Override
        @NotNull
        public IJsonValue getParsed(@NotNull URI uri) {
            return new JSONParser().parse(this.get(uri), uri).getJsonObject();
        }
    }
}

