/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.json;

import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.JsonParseException;
import com.github.erosb.jsonsKema.JsonParser;
import eu.europa.esig.json.JsonObjectWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;

public class JSONParser {
    private static final URI EMPTY_URI = URI.create("");

    protected JsonObjectWrapper parse(String json) {
        return this.parse(json, EMPTY_URI);
    }

    protected JsonObjectWrapper parse(String json, URI uri) {
        Objects.requireNonNull(json, "JSON String cannot be null!");
        Objects.requireNonNull(uri, "URI cannot be null!");
        try {
            return new JsonObjectWrapper((JsonObject)new JsonParser(json, uri).parse());
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(String.format("Unable to parse JSON document! Reason : %s", e.getMessage()), e);
        }
    }

    public JsonObjectWrapper parse(File file) {
        return this.parse(file, EMPTY_URI);
    }

    public JsonObjectWrapper parse(File file, URI uri) {
        JsonObjectWrapper jsonObjectWrapper;
        block8: {
            Objects.requireNonNull(file, "File cannot be null!");
            Objects.requireNonNull(uri, "URI cannot be null!");
            InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                jsonObjectWrapper = this.parse(is, uri);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Unable to parse a file with name '%s'", file.getName()));
                }
            }
            is.close();
        }
        return jsonObjectWrapper;
    }

    public JsonObjectWrapper parse(InputStream inputStream) {
        return this.parse(inputStream, EMPTY_URI);
    }

    public JsonObjectWrapper parse(InputStream inputStream, URI uri) {
        JsonObjectWrapper jsonObjectWrapper;
        block9: {
            Objects.requireNonNull(inputStream, "InputStream cannot be null!");
            Objects.requireNonNull(uri, "URI cannot be null!");
            InputStream is = inputStream;
            try {
                jsonObjectWrapper = new JsonObjectWrapper((JsonObject)new JsonParser(is, uri).parse());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Unable to read a scheme InputStream! Reason : %s", e.getMessage()), e);
                }
                catch (JsonParseException e) {
                    throw new IllegalArgumentException(String.format("Unable to parse JSON document! Reason : %s", e.getMessage()), e);
                }
            }
            is.close();
        }
        return jsonObjectWrapper;
    }
}

