/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.tsl;

import eu.europa.esig.dss.jaxb.common.XSDAbstractUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.definition.XAdESElement;
import eu.europa.esig.dss.xades.definition.tsl.TrustedListNamespace;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.tsl.XAdESTrustedListUtils;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.trustedlist.TrustedListUtils;
import eu.europa.esig.trustedlist211.TrustedList211Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TLStructureVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(TLStructureVerifier.class);
    private static final String TRUSTED_LIST_PARENT_ELEMENT = "TrustServiceStatusList";
    private List<Integer> acceptedTLVersions;
    private boolean signingMode;

    public TLStructureVerifier setAcceptedTLVersions(List<Integer> acceptedTLVersions) {
        this.acceptedTLVersions = acceptedTLVersions;
        return this;
    }

    public TLStructureVerifier setSigningMode(boolean signingMode) {
        this.signingMode = signingMode;
        return this;
    }

    public List<String> validate(DSSDocument dssDocument, Integer tlVersion) {
        Objects.requireNonNull(dssDocument, "Document to be validated cannot be null!");
        return this.validate(DomUtils.buildDOM(dssDocument), tlVersion);
    }

    public List<String> validate(Document document, Integer tlVersion) {
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        if (tlVersion == null) {
            return Collections.singletonList("No TLVersion has been found!");
        }
        if (Utils.isCollectionEmpty(this.acceptedTLVersions)) {
            LOG.debug("No acceptable TL Versions have been defined. The structural validation is skipped.");
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.validateNamespace(document));
        if (!this.acceptedTLVersions.contains(tlVersion)) {
            errors.add(String.format("The TL Version '%s' is not acceptable!", tlVersion));
        } else if (XAdESTrustedListUtils.TL_V5_IDENTIFIER.equals(tlVersion)) {
            errors.addAll(this.validateTrustedListV5(document));
        } else if (XAdESTrustedListUtils.TL_V6_IDENTIFIER.equals(tlVersion)) {
            errors.addAll(this.validateTrustedListV6(document));
        }
        return errors;
    }

    protected List<String> validateTrustedListV5(Document document) {
        ArrayList<String> errors = new ArrayList<String>();
        List<String> xsdValidationErrors = this.validateAgainstXSD(document, TrustedList211Utils.getInstance());
        if (Utils.isCollectionNotEmpty(xsdValidationErrors)) {
            errors.addAll(xsdValidationErrors);
        }
        Element signatureElement = this.getSignatureElement(document);
        errors.addAll(this.verifySignatureElementPresence(signatureElement));
        return errors;
    }

    protected List<String> validateTrustedListV6(Document document) {
        ArrayList<String> errors = new ArrayList<String>();
        List<String> xsdValidationErrors = this.validateAgainstXSD(document, TrustedListUtils.getInstance());
        if (Utils.isCollectionNotEmpty(xsdValidationErrors)) {
            errors.addAll(xsdValidationErrors);
        }
        Element signatureElement = this.getSignatureElement(document);
        errors.addAll(this.verifySignatureElementPresence(signatureElement));
        List<String> v2ConformityErrors = this.validateSignatureElement(signatureElement, true);
        if (Utils.isCollectionNotEmpty(v2ConformityErrors)) {
            errors.addAll(v2ConformityErrors);
        }
        return errors;
    }

    private List<String> validateAgainstXSD(Document document, XSDAbstractUtils xsdUtils) {
        return xsdUtils.validateAgainstXSD(new DOMSource(document));
    }

    private List<String> validateNamespace(Document documentDom) {
        Element documentElement = documentDom.getDocumentElement();
        if (!TRUSTED_LIST_PARENT_ELEMENT.equals(documentElement.getLocalName()) || !TrustedListNamespace.NS.getUri().equals(documentElement.getNamespaceURI())) {
            return Collections.singletonList(String.format("The root of XML Trusted List shall be %s:%s element!", TrustedListNamespace.NS.getPrefix(), TRUSTED_LIST_PARENT_ELEMENT));
        }
        return Collections.emptyList();
    }

    private Element getSignatureElement(Document documentDom) {
        Element documentElement = documentDom.getDocumentElement();
        return this.getChildElement(documentElement, XMLDSigElement.SIGNATURE);
    }

    private List<String> verifySignatureElementPresence(Element dsSignature) {
        if (this.signingMode) {
            if (dsSignature != null) {
                return Collections.singletonList("The ds:Signature element shall not be present for XML Trusted List signing!");
            }
        } else if (dsSignature == null) {
            return Collections.singletonList("No ds:Signature element is present!");
        }
        return Collections.emptyList();
    }

    private List<String> validateSignatureElement(Element dsSignature, boolean v2Expected) {
        List<Element> list;
        if (dsSignature == null || this.signingMode) {
            return Collections.emptyList();
        }
        List<Element> objects = this.getChildElements(dsSignature, XMLDSigElement.OBJECT);
        if (Utils.isCollectionEmpty(objects)) {
            return Collections.singletonList("No ds:Object elements are present!");
        }
        Element qualifyingProperties = this.getQualifyingPropertiesElement(objects);
        if (qualifyingProperties == null) {
            return Collections.singletonList("No xades:QualifyingProperties element has been found!");
        }
        Element signedProperties = this.getChildElement(qualifyingProperties, XAdES132Element.SIGNED_PROPERTIES);
        if (signedProperties == null) {
            return Collections.singletonList("No xades:SignedProperties element has been found!");
        }
        Element signedSignatureProperties = this.getChildElement(signedProperties, XAdES132Element.SIGNED_SIGNATURE_PROPERTIES);
        if (signedSignatureProperties == null) {
            return Collections.singletonList("No xades:SignedSignatureProperties element has been found!");
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        List<Element> signingCertificateElements = this.getMultipleElements(signedSignatureProperties, XAdES132Element.SIGNING_CERTIFICATE, XAdES132Element.SIGNING_CERTIFICATE_V2);
        if (Utils.isCollectionNotEmpty(signingCertificateElements)) {
            for (Element element : signingCertificateElements) {
                if (!(v2Expected ^ this.doesMatch(element, XAdES132Element.SIGNING_CERTIFICATE_V2))) continue;
                errorMessages.add(String.format("%s element shall not be present!", element.getLocalName()));
            }
        } else {
            errorMessages.add(String.format("No xades:SigningCertificate%s element has been found!", v2Expected ? "V2" : ""));
        }
        List<Element> signatureProductionPlaceElements = this.getMultipleElements(signedSignatureProperties, XAdES132Element.SIGNATURE_PRODUCTION_PLACE, XAdES132Element.SIGNATURE_PRODUCTION_PLACE_V2);
        if (Utils.isCollectionNotEmpty(signatureProductionPlaceElements)) {
            for (Element signatureProductionPlace : signatureProductionPlaceElements) {
                if (!(v2Expected ^ this.doesMatch(signatureProductionPlace, XAdES132Element.SIGNATURE_PRODUCTION_PLACE_V2))) continue;
                errorMessages.add(String.format("%s element shall not be present!", signatureProductionPlace.getLocalName()));
            }
        }
        if (Utils.isCollectionNotEmpty(list = this.getMultipleElements(signedSignatureProperties, XAdES132Element.SIGNER_ROLE, XAdES132Element.SIGNER_ROLE_V2))) {
            for (Element signerRole : list) {
                if (!(v2Expected ^ this.doesMatch(signerRole, XAdES132Element.SIGNER_ROLE_V2))) continue;
                errorMessages.add(String.format("%s element shall not be present!", signerRole.getLocalName()));
            }
        }
        return errorMessages;
    }

    private Element getQualifyingPropertiesElement(List<Element> objects) {
        for (Element object : objects) {
            Element qualifyingProperties = this.getChildElement(object, XAdES132Element.QUALIFYING_PROPERTIES);
            if (qualifyingProperties == null) continue;
            return qualifyingProperties;
        }
        return null;
    }

    private List<Element> getMultipleElements(Element signedSignatureProperties, XAdESElement ... targetElements) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (XAdESElement targetElement : targetElements) {
            List<Element> signingCertificates = this.getChildElements(signedSignatureProperties, targetElement);
            if (!Utils.isCollectionNotEmpty(signingCertificates)) continue;
            result.addAll(signingCertificates);
        }
        return result;
    }

    private Element getChildElement(Element parentElement, DSSElement targetElement) {
        List<Element> childrenList = this.getChildElements(parentElement, targetElement);
        if (Utils.collectionSize(childrenList) == 1) {
            return childrenList.get(0);
        }
        return null;
    }

    private List<Element> getChildElements(Element parentElement, DSSElement targetElement) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList childNodes = parentElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element childElement;
            Node childNode = childNodes.item(i);
            if (1 != childNode.getNodeType() || !this.doesMatch(childElement = (Element)childNode, targetElement)) continue;
            children.add(childElement);
        }
        return children;
    }

    private boolean doesMatch(Element element, DSSElement dssElement) {
        return dssElement.isSameTagName(element.getLocalName()) && dssElement.getURI().equals(element.getNamespaceURI());
    }

    static {
        DomUtils.registerNamespace(TrustedListNamespace.NS);
    }
}

