/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.validation.dto;

import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DataToValidateDTO {
    private RemoteDocument signedDocument;
    private List<RemoteDocument> originalDocuments;
    private RemoteDocument policy;
    private RemoteDocument cryptographicSuite;
    private Date validationTime;
    private List<RemoteDocument> evidenceRecords;
    private TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    private String signatureId;

    public DataToValidateDTO() {
    }

    public DataToValidateDTO(RemoteDocument signedDocument, RemoteDocument originalDocument, RemoteDocument policy) {
        this(signedDocument, Collections.singletonList(originalDocument), policy);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, RemoteDocument originalDocument, RemoteDocument policy, RemoteDocument cryptographicSuite) {
        this(signedDocument, Collections.singletonList(originalDocument), policy, cryptographicSuite);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, RemoteDocument originalDocument, Date validationTime, RemoteDocument policy) {
        this(signedDocument, Collections.singletonList(originalDocument), validationTime, policy);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, RemoteDocument originalDocument, Date validationTime, RemoteDocument policy, RemoteDocument cryptographicSuite) {
        this(signedDocument, Collections.singletonList(originalDocument), validationTime, policy, cryptographicSuite);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, RemoteDocument policy) {
        this(signedDocument, originalDocuments, policy, Collections.emptyList(), null);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, RemoteDocument policy, RemoteDocument cryptographicSuite) {
        this(signedDocument, originalDocuments, policy, cryptographicSuite, Collections.emptyList(), null);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, Date validationTime, RemoteDocument policy) {
        this(signedDocument, originalDocuments, validationTime, policy, Collections.emptyList(), null);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, Date validationTime, RemoteDocument policy, RemoteDocument cryptographicSuite) {
        this(signedDocument, originalDocuments, validationTime, policy, cryptographicSuite, Collections.emptyList(), null);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, RemoteDocument policy, List<RemoteDocument> evidenceRecords) {
        this(signedDocument, originalDocuments, policy, evidenceRecords, null);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, RemoteDocument policy, RemoteDocument cryptographicSuite, List<RemoteDocument> evidenceRecords) {
        this(signedDocument, originalDocuments, policy, cryptographicSuite, evidenceRecords, null);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, Date validationTime, RemoteDocument policy, List<RemoteDocument> evidenceRecords) {
        this(signedDocument, originalDocuments, validationTime, policy, evidenceRecords, null);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, Date validationTime, RemoteDocument policy, RemoteDocument cryptographicSuite, List<RemoteDocument> evidenceRecords) {
        this(signedDocument, originalDocuments, validationTime, policy, cryptographicSuite, evidenceRecords, null);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, RemoteDocument originalDocument, RemoteDocument policy, String signatureId) {
        this(signedDocument, Collections.singletonList(originalDocument), policy, signatureId);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, RemoteDocument originalDocument, RemoteDocument policy, RemoteDocument cryptographicSuite, String signatureId) {
        this(signedDocument, Collections.singletonList(originalDocument), policy, cryptographicSuite, signatureId);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, RemoteDocument policy, String signatureId) {
        this(signedDocument, originalDocuments, policy, Collections.emptyList(), signatureId);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, RemoteDocument policy, RemoteDocument cryptographicSuite, String signatureId) {
        this(signedDocument, originalDocuments, policy, cryptographicSuite, Collections.emptyList(), signatureId);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, RemoteDocument policy, List<RemoteDocument> evidenceRecords, String signatureId) {
        this(signedDocument, originalDocuments, (Date)null, policy, evidenceRecords, signatureId);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, RemoteDocument policy, RemoteDocument cryptographicSuite, List<RemoteDocument> evidenceRecords, String signatureId) {
        this(signedDocument, originalDocuments, null, policy, cryptographicSuite, evidenceRecords, signatureId);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, Date validationTime, RemoteDocument policy, List<RemoteDocument> evidenceRecords, String signatureId) {
        this(signedDocument, originalDocuments, validationTime, policy, null, evidenceRecords, signatureId);
    }

    public DataToValidateDTO(RemoteDocument signedDocument, List<RemoteDocument> originalDocuments, Date validationTime, RemoteDocument policy, RemoteDocument cryptographicSuite, List<RemoteDocument> evidenceRecords, String signatureId) {
        this.signedDocument = signedDocument;
        this.originalDocuments = originalDocuments;
        this.validationTime = validationTime;
        this.policy = policy;
        this.cryptographicSuite = cryptographicSuite;
        this.evidenceRecords = evidenceRecords;
        this.signatureId = signatureId;
    }

    public RemoteDocument getSignedDocument() {
        return this.signedDocument;
    }

    public void setSignedDocument(RemoteDocument signedDocument) {
        this.signedDocument = signedDocument;
    }

    public List<RemoteDocument> getOriginalDocuments() {
        return this.originalDocuments;
    }

    public void setOriginalDocuments(List<RemoteDocument> originalDocuments) {
        this.originalDocuments = originalDocuments;
    }

    public RemoteDocument getPolicy() {
        return this.policy;
    }

    public void setPolicy(RemoteDocument policy) {
        this.policy = policy;
    }

    public RemoteDocument getCryptographicSuite() {
        return this.cryptographicSuite;
    }

    public void setCryptographicSuite(RemoteDocument cryptographicSuite) {
        this.cryptographicSuite = cryptographicSuite;
    }

    public Date getValidationTime() {
        return this.validationTime;
    }

    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    public List<RemoteDocument> getEvidenceRecords() {
        return this.evidenceRecords;
    }

    public void setEvidenceRecords(List<RemoteDocument> evidenceRecords) {
        this.evidenceRecords = evidenceRecords;
    }

    public TokenExtractionStrategy getTokenExtractionStrategy() {
        return this.tokenExtractionStrategy;
    }

    public void setTokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        this.tokenExtractionStrategy = tokenExtractionStrategy;
    }

    public String getSignatureId() {
        return this.signatureId;
    }

    public void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }
}

