/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.qwac;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.qwac.LinkHeaderParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QWACUtils {
    private static final Logger LOG = LoggerFactory.getLogger(QWACUtils.class);
    private static final String HEADER_LINK = "Link";
    private static final String RELATION_TYPE = "rel";
    private static final String TLS_CERTIFICATE_BINDING = "tls-certificate-binding";

    private QWACUtils() {
    }

    public static String getTLSCertificateBindingUrl(Map<String, List<String>> headers) {
        if (headers == null) {
            return null;
        }
        List<String> headerValues = headers.get(HEADER_LINK);
        if (headerValues == null) {
            LOG.debug("No Link header found in the obtained map of headers.");
            return null;
        }
        for (String linkHeaderValue : headerValues) {
            try {
                List<LinkHeaderParser.LinkHeader> linkHeader = new LinkHeaderParser().parse(linkHeaderValue);
                if (!Utils.isCollectionNotEmpty(linkHeader)) continue;
                for (LinkHeaderParser.LinkHeader singleHeaderValue : linkHeader) {
                    if (!QWACUtils.isTLSCertificateBindingRel(singleHeaderValue)) continue;
                    LOG.debug("'Link' header value was obtained from with value '{}'", (Object)singleHeaderValue.getUrl());
                    return singleHeaderValue.getUrl();
                }
            }
            catch (Exception e) {
                LOG.debug("An error occurred on processing a 'Link' header value : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        LOG.debug("No Link header contains a rel value of tls-certificate-binding.");
        return null;
    }

    private static boolean isTLSCertificateBindingRel(LinkHeaderParser.LinkHeader linkHeader) {
        return TLS_CERTIFICATE_BINDING.equals(linkHeader.getAttributes().get(RELATION_TYPE));
    }

    public static List<CertificateWrapper> getIdentifiedTLSCertificates(SignatureWrapper signature, List<CertificateWrapper> certificates) {
        ArrayList<CertificateWrapper> result = new ArrayList<CertificateWrapper>();
        for (XmlDigestMatcher digestMatcher : signature.getDigestMatchers()) {
            if (DigestMatcherType.SIG_D_ENTRY != digestMatcher.getType() || !digestMatcher.isDataFound() || !digestMatcher.isDataIntact() || digestMatcher.getDocumentName() == null) continue;
            for (CertificateWrapper certificate : certificates) {
                if (!digestMatcher.getDocumentName().equals(certificate.getId())) continue;
                result.add(certificate);
            }
        }
        return result;
    }
}

