/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.qwac.QWACUtils;
import java.util.Collections;

public class TLSCertificateBindingPresentInSignatureCheck
extends ChainItem<XmlValidationQWACProcess> {
    private final CertificateWrapper tlsCertificate;
    private final SignatureWrapper bindingSignature;

    public TLSCertificateBindingPresentInSignatureCheck(I18nProvider i18nProvider, XmlValidationQWACProcess result, CertificateWrapper tlsCertificate, SignatureWrapper bindingSignature, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.tlsCertificate = tlsCertificate;
        this.bindingSignature = bindingSignature;
    }

    @Override
    protected boolean process() {
        return this.isTLSCertificateIdentified();
    }

    private boolean isTLSCertificateIdentified() {
        return Utils.isCollectionNotEmpty(QWACUtils.getIdentifiedTLSCertificates(this.bindingSignature, Collections.singletonList(this.tlsCertificate)));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TLS_CERT_BINDING_CERT_IDENTIFIED;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TLS_CERT_BINDING_CERT_IDENTIFIED_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

