/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateQualificationProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlQWACProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.QWACProfile;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.QWAC1ValidationProcessBlock;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.TLSCertificateSupportedByQWAC2ValidationProcessBlock;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.QWACValidationResultCheck;
import java.util.Map;

public class QWACForTLSCertificateValidationBlock
extends Chain<XmlQWACProcess> {
    private final DiagnosticData diagnosticData;
    private final CertificateWrapper certificate;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final XmlCertificateQualificationProcess certificateQualification;
    private final QWACProfile bindingCertificateProfile;
    private final String websiteUrl;

    public QWACForTLSCertificateValidationBlock(I18nProvider i18nProvider, DiagnosticData diagnosticData, CertificateWrapper certificate, Map<String, XmlBasicBuildingBlocks> bbbs, XmlCertificateQualificationProcess certificateQualification, QWACProfile bindingCertificateProfile, String websiteUrl) {
        super(i18nProvider, new XmlQWACProcess());
        ((XmlQWACProcess)this.result).setId(certificate.getId());
        this.certificate = certificate;
        this.diagnosticData = diagnosticData;
        this.bbbs = bbbs;
        this.certificateQualification = certificateQualification;
        this.bindingCertificateProfile = bindingCertificateProfile;
        this.websiteUrl = websiteUrl;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.QWAC_VALIDATION;
    }

    @Override
    protected void initChain() {
        XmlBasicBuildingBlocks certBBB = this.bbbs.get(this.certificate.getId());
        if (certBBB == null) {
            throw new IllegalStateException(String.format("The certificate basic validation process shall be performed! No BasicBuildingBlock found for a certificate with Id '%s'", this.certificate.getId()));
        }
        QWAC1ValidationProcessBlock qwac1Process = new QWAC1ValidationProcessBlock(this.i18nProvider, this.diagnosticData.getValidationDate(), this.certificate, certBBB.getConclusion(), this.certificateQualification, this.websiteUrl);
        XmlValidationQWACProcess qwac1ValidationResult = (XmlValidationQWACProcess)qwac1Process.execute();
        ((XmlQWACProcess)this.result).getValidationQWACProcess().add(qwac1ValidationResult);
        TLSCertificateSupportedByQWAC2ValidationProcessBlock tlsCertificateProcess = new TLSCertificateSupportedByQWAC2ValidationProcessBlock(this.i18nProvider, this.diagnosticData, this.certificate, this.getTokenValidationConclusion(this.certificate), this.getTokenValidationConclusion(this.diagnosticData.getTLSCertificateBindingSignature()), this.bindingCertificateProfile, this.websiteUrl);
        XmlValidationQWACProcess tlsCertificateValidationResult = (XmlValidationQWACProcess)tlsCertificateProcess.execute();
        ((XmlQWACProcess)this.result).getValidationQWACProcess().add(tlsCertificateValidationResult);
        ChainItem<XmlQWACProcess> item = this.firstItem = this.qwacValidation(qwac1ValidationResult, tlsCertificateValidationResult);
        if (this.isValid(qwac1ValidationResult)) {
            ((XmlQWACProcess)this.result).setQWACType(qwac1Process.getQWACProfile());
        } else if (this.isValid(tlsCertificateValidationResult)) {
            ((XmlQWACProcess)this.result).setQWACType(tlsCertificateProcess.getQWACProfile());
        } else {
            ((XmlQWACProcess)this.result).setQWACType(QWACProfile.NOT_QWAC);
        }
    }

    private ChainItem<XmlQWACProcess> qwacValidation(XmlValidationQWACProcess ... qwacValidationProcesses) {
        return new QWACValidationResultCheck(this.i18nProvider, (XmlQWACProcess)this.result, qwacValidationProcesses, this.getFailLevelRule());
    }

    private XmlConclusion getTokenValidationConclusion(TokenProxy token) {
        if (token != null) {
            XmlBasicBuildingBlocks bbb = this.bbbs.get(token.getId());
            if (bbb == null) {
                throw new IllegalStateException("The Basic validation shall be performed!");
            }
            return bbb.getConclusion();
        }
        return null;
    }
}

