/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.vci.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlVCI;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignaturePolicyType;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;

public class SignaturePolicyIdentifierCheck
extends AbstractMultiValuesCheckItem<XmlVCI> {
    private final SignatureWrapper signature;
    private final MultiValuesRule multiValues;

    public SignaturePolicyIdentifierCheck(I18nProvider i18nProvider, XmlVCI result, SignatureWrapper signature, MultiValuesRule multiValues) {
        super(i18nProvider, result, multiValues);
        this.signature = signature;
        this.multiValues = multiValues;
    }

    @Override
    protected boolean process() {
        String policyId = this.signature.getPolicyId();
        if (this.multiValues.getValues().contains(SignaturePolicyType.NO_POLICY.name()) && Utils.isStringEmpty(policyId)) {
            return true;
        }
        if (this.multiValues.getValues().contains(SignaturePolicyType.ANY_POLICY.name()) && Utils.isStringNotEmpty(policyId)) {
            return true;
        }
        if (this.multiValues.getValues().contains(SignaturePolicyType.IMPLICIT_POLICY.name()) && Utils.areStringsEqual(SignaturePolicyType.IMPLICIT_POLICY.name(), policyId)) {
            return true;
        }
        return this.processValueCheck(policyId);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_VCI_ISPK;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_VCI_ISPK_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.POLICY_PROCESSING_ERROR;
    }
}

