/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.checks.AlgorithmObsolescenceValidationCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.AllCertificatesInPathReferencedCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateAttributePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateReferencesValidityCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.UnicitySigningCertificateAttributeCheck;
import java.util.Date;

public abstract class AbstractAcceptanceValidation<T extends AbstractTokenProxy>
extends Chain<XmlSAV> {
    protected final T token;
    protected final Date currentTime;
    protected final Context context;
    protected final XmlAOV aov;
    protected final ValidationPolicy validationPolicy;

    protected AbstractAcceptanceValidation(I18nProvider i18nProvider, T token, Date currentTime, Context context, XmlAOV aov, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlSAV());
        this.token = token;
        this.currentTime = currentTime;
        this.context = context;
        this.aov = aov;
        this.validationPolicy = validationPolicy;
    }

    protected ChainItem<XmlSAV> signingCertificateAttributePresent() {
        LevelRule constraint = this.validationPolicy.getSigningCertificateAttributePresentConstraint(this.context);
        return new SigningCertificateAttributePresentCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> unicitySigningCertificateAttribute() {
        LevelRule constraint = this.validationPolicy.getUnicitySigningCertificateAttributeConstraint(this.context);
        return new UnicitySigningCertificateAttributeCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> signingCertificateReferencesValidity() {
        LevelRule constraint = this.validationPolicy.getSigningCertificateRefersCertificateChainConstraint(this.context);
        return new SigningCertificateReferencesValidityCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> allCertificatesInPathReferenced() {
        LevelRule constraint = this.validationPolicy.getReferencesToAllCertificateChainPresentConstraint(this.context);
        return new AllCertificatesInPathReferencedCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> cryptographic(ChainItem<XmlSAV> item) {
        MessageTag position = ValidationProcessUtils.getCryptoPosition(this.context);
        if (item == null) {
            this.firstItem = this.algorithmObsolescenceValidationCheck((XmlSAV)this.result, this.aov, position);
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.algorithmObsolescenceValidationCheck((XmlSAV)this.result, this.aov, position));
        }
        return item;
    }

    protected ChainItem<XmlSAV> algorithmObsolescenceValidationCheck(XmlSAV result, XmlAOV aovResult, MessageTag position) {
        return new AlgorithmObsolescenceValidationCheck<XmlSAV>(this.i18nProvider, result, aovResult, this.currentTime, position, this.token.getId());
    }
}

