/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.Objects;

public class ReferenceDataNameMatchCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final XmlDigestMatcher digestMatcher;

    public ReferenceDataNameMatchCheck(I18nProvider i18nProvider, T result, XmlDigestMatcher digestMatcher, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.digestMatcher = digestMatcher;
    }

    @Override
    protected boolean process() {
        return this.digestMatcher.getUri() != null && this.digestMatcher.getUri().equals(this.digestMatcher.getDocumentName());
    }

    @Override
    protected MessageTag getMessageTag() {
        if (Objects.requireNonNull(this.digestMatcher.getType()) == DigestMatcherType.MANIFEST_ENTRY) {
            return MessageTag.BBB_CV_DMENMND;
        }
        return MessageTag.BBB_CV_DRNMND;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        if (Objects.requireNonNull(this.digestMatcher.getType()) == DigestMatcherType.MANIFEST_ENTRY) {
            return MessageTag.BBB_CV_DMENMND_ANS;
        }
        return MessageTag.BBB_CV_DRNMND_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIGNED_DATA_NOT_FOUND;
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.REFERENCE_NAME_CHECK, this.digestMatcher.getUri(), this.digestMatcher.getDocumentName());
    }
}

