/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EvidenceRecordTimestampType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.EvidenceRecordHashTreeRenewalTimestampCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ManifestEntryExistenceCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ManifestEntryGroupCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataExistenceCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataIntactCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataNameMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.SignatureIntactCheck;
import java.util.List;

public class CryptographicVerification
extends Chain<XmlCV> {
    private final DiagnosticData diagnosticData;
    private final TokenProxy token;
    private final ValidationPolicy validationPolicy;
    private final Context context;

    public CryptographicVerification(I18nProvider i18nProvider, DiagnosticData diagnosticData, TokenProxy token, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlCV());
        this.diagnosticData = diagnosticData;
        this.token = token;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.CRYPTOGRAPHIC_VERIFICATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCV> item = null;
        List<XmlDigestMatcher> digestMatchers = this.token.getDigestMatchers();
        boolean containsManifest = this.containsManifest(digestMatchers);
        if (Utils.isCollectionNotEmpty(digestMatchers)) {
            for (XmlDigestMatcher digestMatcher : digestMatchers) {
                if (DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE == digestMatcher.getType() || containsManifest && DigestMatcherType.MANIFEST_ENTRY == digestMatcher.getType()) continue;
                ChainItem<XmlCV> referenceDataFound = this.referenceDataFound(digestMatcher);
                if (item == null) {
                    item = referenceDataFound;
                    this.firstItem = item;
                } else {
                    item = item.setNextItem(referenceDataFound);
                }
                if (digestMatcher.isDataFound()) {
                    item = item.setNextItem(this.referenceDataIntact(digestMatcher));
                }
                if (!Utils.isStringNotEmpty(digestMatcher.getUri()) || !Utils.isStringNotEmpty(digestMatcher.getDocumentName())) continue;
                item = item.setNextItem(this.referenceDataNameCheck(digestMatcher));
            }
            if (this.isEvidenceRecordHashTreeRenewalTimestamp()) {
                ChainItem<XmlCV> evidenceRecordHashTreeRenewalTimestamp = this.evidenceRecordHashTreeRenewalTimestamp();
                if (item == null) {
                    item = evidenceRecordHashTreeRenewalTimestamp;
                    this.firstItem = item;
                } else {
                    item = item.setNextItem(evidenceRecordHashTreeRenewalTimestamp);
                }
            }
        }
        if (containsManifest) {
            ChainItem<XmlCV> manifestEntryFound = this.manifestEntryExistence(digestMatchers);
            if (item == null) {
                item = manifestEntryFound;
                this.firstItem = item;
            } else {
                item = item.setNextItem(manifestEntryFound);
            }
            if (this.containsManifestEntries(digestMatchers)) {
                item = item.setNextItem(this.manifestEntryGroup(digestMatchers));
                for (XmlDigestMatcher digestMatcher : digestMatchers) {
                    if (DigestMatcherType.MANIFEST_ENTRY != digestMatcher.getType()) continue;
                    if (digestMatcher.isDataFound()) {
                        item = item.setNextItem(this.manifestEntryIntact(digestMatcher));
                    }
                    if (!Utils.isStringNotEmpty(digestMatcher.getUri()) || !Utils.isStringNotEmpty(digestMatcher.getDocumentName())) continue;
                    item = item.setNextItem(this.manifestEntryNameCheck(digestMatcher));
                }
            }
        }
        ChainItem<XmlCV> signatureIntact = this.signatureIntact();
        if (item == null) {
            this.firstItem = item = signatureIntact;
        } else {
            item = item.setNextItem(signatureIntact);
        }
    }

    private boolean containsManifest(List<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.stream().anyMatch(d -> DigestMatcherType.MANIFEST == d.getType());
    }

    private boolean containsManifestEntries(List<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.stream().anyMatch(d -> DigestMatcherType.MANIFEST_ENTRY == d.getType() && d.isDataFound());
    }

    private ChainItem<XmlCV> referenceDataFound(XmlDigestMatcher digestMatcher) {
        LevelRule constraint = this.validationPolicy.getReferenceDataExistenceConstraint(this.context);
        return new ReferenceDataExistenceCheck<XmlCV>(this.i18nProvider, (XmlCV)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlCV> referenceDataIntact(XmlDigestMatcher digestMatcher) {
        LevelRule constraint = this.validationPolicy.getReferenceDataIntactConstraint(this.context);
        return new ReferenceDataIntactCheck<XmlCV>(this.i18nProvider, (XmlCV)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlCV> referenceDataNameCheck(XmlDigestMatcher digestMatcher) {
        LevelRule constraint = this.validationPolicy.getReferenceDataNameMatchConstraint(this.context);
        return new ReferenceDataNameMatchCheck<XmlCV>(this.i18nProvider, (XmlCV)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlCV> manifestEntryExistence(List<XmlDigestMatcher> digestMatchers) {
        LevelRule constraint = this.validationPolicy.getManifestEntryObjectExistenceConstraint(this.context);
        return new ManifestEntryExistenceCheck(this.i18nProvider, (XmlCV)this.result, digestMatchers, constraint);
    }

    private ChainItem<XmlCV> manifestEntryGroup(List<XmlDigestMatcher> digestMatchers) {
        LevelRule constraint = this.validationPolicy.getManifestEntryObjectGroupConstraint(this.context);
        return new ManifestEntryGroupCheck(this.i18nProvider, (XmlCV)this.result, digestMatchers, constraint);
    }

    private ChainItem<XmlCV> manifestEntryIntact(XmlDigestMatcher digestMatcher) {
        LevelRule constraint = this.validationPolicy.getManifestEntryObjectIntactConstraint(this.context);
        return new ReferenceDataIntactCheck<XmlCV>(this.i18nProvider, (XmlCV)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlCV> manifestEntryNameCheck(XmlDigestMatcher digestMatcher) {
        LevelRule constraint = this.validationPolicy.getManifestEntryNameMatchConstraint(this.context);
        return new ReferenceDataNameMatchCheck<XmlCV>(this.i18nProvider, (XmlCV)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlCV> signatureIntact() {
        LevelRule constraint = this.validationPolicy.getSignatureIntactConstraint(this.context);
        return new SignatureIntactCheck<XmlCV>(this.i18nProvider, (XmlCV)this.result, this.token, this.context, constraint);
    }

    private boolean isEvidenceRecordHashTreeRenewalTimestamp() {
        if (this.token instanceof TimestampWrapper) {
            TimestampWrapper timestampWrapper = (TimestampWrapper)this.token;
            return timestampWrapper.getType().isEvidenceRecordTimestamp() && EvidenceRecordTimestampType.HASH_TREE_RENEWAL_ARCHIVE_TIMESTAMP == timestampWrapper.getEvidenceRecordTimestampType();
        }
        return false;
    }

    private ChainItem<XmlCV> evidenceRecordHashTreeRenewalTimestamp() {
        LevelRule constraint = this.validationPolicy.getEvidenceRecordHashTreeRenewalConstraint();
        return new EvidenceRecordHashTreeRenewalTimestampCheck(this.i18nProvider, (XmlCV)this.result, this.diagnosticData, (TimestampWrapper)this.token, constraint);
    }
}

