/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;
import java.util.List;

public class AlgorithmObsolescenceValidationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    protected final XmlAOV aovResult;
    protected final Date validationDate;
    protected final MessageTag position;
    protected final XmlBlockType blockType;

    public AlgorithmObsolescenceValidationCheck(I18nProvider i18nProvider, T result, XmlAOV aovResult, Date validationDate, MessageTag position, String tokenId) {
        this(i18nProvider, result, aovResult, validationDate, position, XmlBlockType.AOV, tokenId);
    }

    public AlgorithmObsolescenceValidationCheck(I18nProvider i18nProvider, T result, XmlAOV aovResult, Date validationDate, MessageTag position, XmlBlockType blockType, String tokenId) {
        super(i18nProvider, result, AlgorithmObsolescenceValidationCheck.getLevelRule(aovResult), tokenId);
        this.aovResult = aovResult;
        this.validationDate = validationDate;
        this.position = position;
        this.blockType = blockType;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return this.blockType;
    }

    private static LevelRule getLevelRule(XmlAOV aovResult) {
        if (Utils.isCollectionNotEmpty(aovResult.getConclusion().getErrors())) {
            return ValidationProcessUtils.getLevelRule(Level.FAIL);
        }
        if (Utils.isCollectionNotEmpty(aovResult.getConclusion().getWarnings())) {
            return ValidationProcessUtils.getLevelRule(Level.WARN);
        }
        if (Utils.isCollectionNotEmpty(aovResult.getConclusion().getInfos())) {
            return ValidationProcessUtils.getLevelRule(Level.INFORM);
        }
        return ValidationProcessUtils.getLevelRule(Level.FAIL);
    }

    @Override
    protected boolean process() {
        return this.isValid(this.aovResult);
    }

    @Override
    protected boolean isValidConclusion(XmlConclusion conclusion) {
        return super.isValidConclusion(conclusion) && Utils.isCollectionEmpty(conclusion.getWarnings()) && Utils.isCollectionEmpty(conclusion.getInfos());
    }

    @Override
    protected String buildAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (this.process()) {
            XmlCryptographicValidation cryptographicValidation = ValidationProcessUtils.getPrimaryCryptographicValidation(this.aovResult);
            if (cryptographicValidation != null) {
                XmlCryptographicAlgorithm algorithm = cryptographicValidation.getAlgorithm();
                if (Utils.isStringNotEmpty(algorithm.getKeyLength())) {
                    return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_KEY_SIZE, algorithm.getName(), algorithm.getKeyLength(), dateTime);
                }
                return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS, algorithm.getName(), dateTime);
            }
            return null;
        }
        return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE, this.getErrorMessage(), dateTime);
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.aovResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.aovResult.getConclusion().getSubIndication();
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ACCM, new Object[]{this.position});
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.ACCM_ANS, new Object[]{this.position});
    }

    protected String getErrorMessage() {
        List<XmlMessage> errors = this.aovResult.getConclusion().getErrors();
        if (Utils.isCollectionNotEmpty(errors)) {
            return errors.iterator().next().getValue();
        }
        List<XmlMessage> warnings = this.aovResult.getConclusion().getWarnings();
        if (Utils.isCollectionNotEmpty(warnings)) {
            return warnings.iterator().next().getValue();
        }
        List<XmlMessage> infos = this.aovResult.getConclusion().getInfos();
        if (Utils.isCollectionNotEmpty(infos)) {
            return infos.iterator().next().getValue();
        }
        return "";
    }

    @Override
    protected List<XmlMessage> getPreviousErrors() {
        return this.aovResult.getConclusion().getErrors();
    }
}

