/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.process.Chain;
import java.util.Date;

public abstract class AbstractAlgorithmCryptographicChecker
extends Chain<XmlCC> {
    protected static final String ALGORITHM_UNIDENTIFIED = "UNIDENTIFIED";
    protected static final String ALGORITHM_UNIDENTIFIED_URN = "urn:etsi:019102:algorithm:unidentified";
    protected final Date validationDate;
    protected final CryptographicSuite cryptographicSuite;
    protected final MessageTag position;
    protected XmlCryptographicAlgorithm cryptographicAlgorithm;

    protected AbstractAlgorithmCryptographicChecker(I18nProvider i18nProvider, Date validationDate, MessageTag position, CryptographicSuite cryptographicSuite) {
        super(i18nProvider, new XmlCC());
        this.validationDate = validationDate;
        this.cryptographicSuite = cryptographicSuite;
        this.position = position;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.CC;
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        ((XmlCC)this.result).setCryptographicValidation(this.getCryptographicValidation());
    }

    protected XmlCryptographicValidation getCryptographicValidation() {
        XmlCryptographicValidation xmlCryptographicValidation = new XmlCryptographicValidation();
        xmlCryptographicValidation.setAlgorithm(this.getAlgorithm());
        xmlCryptographicValidation.setNotAfter(this.getNotAfter());
        xmlCryptographicValidation.setConclusion(((XmlCC)this.result).getConclusion());
        return xmlCryptographicValidation;
    }

    protected abstract XmlCryptographicAlgorithm getAlgorithm();

    protected abstract Date getNotAfter();
}

