/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.certificate;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSimpleCertificateReport;
import eu.europa.esig.dss.validation.executor.AbstractProcessExecutor;
import eu.europa.esig.dss.validation.executor.certificate.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.executor.certificate.DetailedReportForCertificateBuilder;
import eu.europa.esig.dss.validation.executor.certificate.SimpleReportForCertificateBuilder;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import java.util.Objects;

public class DefaultCertificateProcessExecutor
extends AbstractProcessExecutor
implements CertificateProcessExecutor {
    protected String certificateId;

    @Override
    public void setCertificateId(String certificateId) {
        this.certificateId = certificateId;
    }

    @Override
    public CertificateReports execute() {
        this.assertConfigurationValid();
        Objects.requireNonNull(this.certificateId, "The certificate id is missing");
        DiagnosticData diagnosticData = this.getDiagnosticData();
        DetailedReportForCertificateBuilder detailedReportBuilder = this.getDetailedReportBuilder(diagnosticData);
        XmlDetailedReport xmlDetailedReport = detailedReportBuilder.build();
        DetailedReport detailedReport = new DetailedReport(xmlDetailedReport);
        SimpleReportForCertificateBuilder simpleReportBuilder = this.getSimpleReportBuilder(diagnosticData, detailedReport);
        XmlSimpleCertificateReport simpleReport = simpleReportBuilder.build();
        return new CertificateReports(this.jaxbDiagnosticData, xmlDetailedReport, simpleReport);
    }

    protected DiagnosticData getDiagnosticData() {
        return new DiagnosticData(this.jaxbDiagnosticData);
    }

    protected DetailedReportForCertificateBuilder getDetailedReportBuilder(DiagnosticData diagnosticData) {
        return new DetailedReportForCertificateBuilder(this.getI18nProvider(), diagnosticData, this.policy, this.currentTime, this.certificateId);
    }

    protected SimpleReportForCertificateBuilder getSimpleReportBuilder(DiagnosticData diagnosticData, DetailedReport detailedReport) {
        return new SimpleReportForCertificateBuilder(diagnosticData, detailedReport, this.policy, this.currentTime, this.certificateId);
    }
}

