/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.alerts.detections;

import eu.europa.esig.dss.alert.detector.AlertDetector;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.PivotInfo;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public class LOTLLocationChangeDetection
implements AlertDetector<LOTLInfo> {
    private final LOTLSource lotlSource;

    public LOTLLocationChangeDetection(LOTLSource lotlSource) {
        this.lotlSource = lotlSource;
    }

    @Override
    public boolean detect(LOTLInfo info) {
        PivotInfo lastPivotInfo;
        List<PivotInfo> pivotInfos;
        return Utils.areStringsEqual(this.lotlSource.getUrl(), info.getUrl()) && this.lotlSource.isPivotSupport() && Utils.isCollectionNotEmpty(pivotInfos = info.getPivotInfos()) && !Utils.areStringsEqual((lastPivotInfo = pivotInfos.get(pivotInfos.size() - 1)).getLOTLLocation(), info.getUrl());
    }
}

