/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.controller.validationresult;

import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificate;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.simplereport.jaxb.XmlDetails;
import eu.europa.esig.dss.simplereport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.simplereport.jaxb.XmlEvidenceRecords;
import eu.europa.esig.dss.simplereport.jaxb.XmlMessage;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignature;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamps;
import eu.europa.esig.dss.simplereport.jaxb.XmlToken;
import eu.europa.esig.dss.simplereport.jaxb.XmlTrustAnchor;
import eu.europa.esig.dss.simplereport.jaxb.XmlTrustAnchors;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.standalone.controller.AbstractController;
import eu.europa.esig.dss.standalone.exception.ApplicationException;
import eu.europa.esig.dss.utils.Utils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenNodeController
extends AbstractController {
    private static final Logger LOG = LoggerFactory.getLogger(TokenNodeController.class);
    @FXML
    public HBox parentNode;
    @FXML
    public Label signatureIdLabel;
    @FXML
    public Label timestampIdLabel;
    @FXML
    public Label evidenceRecordIdLabel;
    @FXML
    public Label id;
    @FXML
    public HBox filenameContainer;
    @FXML
    public Label filename;
    @FXML
    public HBox qualificationLevelContainer;
    @FXML
    public Label qualificationLevel;
    @FXML
    public HBox qualificationDetailsContainer;
    @FXML
    public TextFlow qualificationDetails;
    @FXML
    public Label indication;
    @FXML
    public HBox adesValidationDetailsContainer;
    @FXML
    public TextFlow adesValidationDetails;
    @FXML
    public HBox signatureFormatContainer;
    @FXML
    public Label signatureFormat;
    @FXML
    public HBox certificateChainContainer;
    @FXML
    public TextFlow certificateChain;
    @FXML
    public HBox claimedSigningTimeContainer;
    @FXML
    public Label claimedSigningTime;
    @FXML
    public HBox bestSignatureTimeContainer;
    @FXML
    public Label bestSignatureTime;
    @FXML
    public HBox productionTimeContainer;
    @FXML
    public Label productionTime;
    @FXML
    public HBox lowestPOEContainer;
    @FXML
    public Label lowestPOE;
    @FXML
    public HBox signatureScopesContainer;
    @FXML
    public TextFlow signatureScopes;
    @FXML
    public HBox signatureTimestampsContainer;
    @FXML
    public VBox signatureTimestamps;
    @FXML
    public HBox signatureEvidenceRecordsContainer;
    @FXML
    public VBox signatureEvidenceRecords;

    public static TokenNodeController loadController() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(TokenNodeController.class.getResource("/fxml/validationresult/token.fxml"));
            loader.load();
            return (TokenNodeController)loader.getController();
        }
        catch (Exception e) {
            LOG.error(String.format("An error occurred: %s", e.getMessage()), e);
            throw new ApplicationException(e);
        }
    }

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.signatureIdLabel.managedProperty().bind(this.signatureIdLabel.visibleProperty());
        this.timestampIdLabel.managedProperty().bind(this.timestampIdLabel.visibleProperty());
        this.evidenceRecordIdLabel.managedProperty().bind(this.evidenceRecordIdLabel.visibleProperty());
        this.filenameContainer.managedProperty().bind(this.filenameContainer.visibleProperty());
        this.qualificationLevelContainer.managedProperty().bind(this.qualificationLevelContainer.visibleProperty());
        this.qualificationDetailsContainer.managedProperty().bind(this.qualificationDetailsContainer.visibleProperty());
        this.adesValidationDetailsContainer.managedProperty().bind(this.adesValidationDetailsContainer.visibleProperty());
        this.signatureFormatContainer.managedProperty().bind(this.signatureFormatContainer.visibleProperty());
        this.certificateChainContainer.managedProperty().bind(this.certificateChainContainer.visibleProperty());
        this.claimedSigningTimeContainer.managedProperty().bind(this.claimedSigningTimeContainer.visibleProperty());
        this.bestSignatureTimeContainer.managedProperty().bind(this.bestSignatureTimeContainer.visibleProperty());
        this.productionTimeContainer.managedProperty().bind(this.productionTimeContainer.visibleProperty());
        this.lowestPOEContainer.managedProperty().bind(this.lowestPOEContainer.visibleProperty());
        this.signatureScopesContainer.managedProperty().bind(this.signatureScopesContainer.visibleProperty());
        this.signatureTimestampsContainer.managedProperty().bind(this.signatureTimestampsContainer.visibleProperty());
        this.signatureEvidenceRecordsContainer.managedProperty().bind(this.signatureEvidenceRecordsContainer.visibleProperty());
    }

    public Node create(XmlToken token) {
        this.id.setText(token.getId());
        this.filename.setText(token.getFilename());
        this.filenameContainer.setVisible(token.getFilename() != null);
        this.qualificationDetails.getChildren().addAll((Collection<Node>)this.getDetails(token.getQualificationDetails()));
        this.qualificationDetailsContainer.setVisible(this.isNotEmpty(token.getQualificationDetails()));
        this.indication.setText(this.getIndicationResultString(token));
        this.indication.setStyle(this.getIndicationStyle(token.getIndication()));
        this.adesValidationDetails.getChildren().addAll((Collection<Node>)this.getDetails(token.getAdESValidationDetails()));
        this.adesValidationDetailsContainer.setVisible(this.isNotEmpty(token.getAdESValidationDetails()));
        this.certificateChain.getChildren().addAll((Collection<Node>)this.getCertificateChain(token.getCertificateChain()));
        this.certificateChainContainer.setVisible(this.isNotEmpty(token.getCertificateChain()));
        this.signatureIdLabel.setVisible(token instanceof XmlSignature);
        this.signatureFormatContainer.setVisible(token instanceof XmlSignature);
        this.claimedSigningTimeContainer.setVisible(token instanceof XmlSignature);
        this.bestSignatureTimeContainer.setVisible(token instanceof XmlSignature);
        this.signatureFormatContainer.setVisible(token instanceof XmlSignature);
        this.signatureTimestampsContainer.setVisible(token instanceof XmlSignature);
        this.signatureEvidenceRecordsContainer.setVisible(token instanceof XmlSignature);
        this.timestampIdLabel.setVisible(token instanceof XmlTimestamp);
        this.productionTimeContainer.setVisible(token instanceof XmlTimestamp);
        this.evidenceRecordIdLabel.setVisible(token instanceof XmlEvidenceRecord);
        this.lowestPOEContainer.setVisible(token instanceof XmlEvidenceRecord);
        if (token instanceof XmlSignature) {
            XmlSignature signature = (XmlSignature)token;
            if (signature.getSignatureLevel() != null) {
                this.qualificationLevel.setText(signature.getSignatureLevel().getValue().getReadable());
            }
            this.qualificationLevelContainer.setVisible(signature.getSignatureLevel() != null);
            this.signatureFormat.setText(signature.getSignatureFormat().toString());
            this.claimedSigningTime.setText(DSSUtils.formatDateToRFC(signature.getSigningTime()));
            this.bestSignatureTime.setText(DSSUtils.formatDateToRFC(signature.getBestSignatureTime()));
            this.signatureScopes.getChildren().addAll((Collection<Node>)this.getSignatureScope(signature.getSignatureScope()));
            this.signatureScopesContainer.setVisible(Utils.isCollectionNotEmpty(signature.getSignatureScope()));
            XmlTimestamps timestamps = signature.getTimestamps();
            if (timestamps != null && Utils.isCollectionNotEmpty(timestamps.getTimestamp())) {
                this.signatureTimestamps.getChildren().addAll((Collection<Node>)this.getSignatureTimestamps(timestamps));
                this.signatureTimestampsContainer.setVisible(true);
            } else {
                this.signatureTimestampsContainer.setVisible(false);
            }
            XmlEvidenceRecords evidenceRecords = signature.getEvidenceRecords();
            if (evidenceRecords != null && Utils.isCollectionNotEmpty(evidenceRecords.getEvidenceRecord())) {
                this.signatureEvidenceRecords.getChildren().addAll((Collection<Node>)this.getSignatureEvidenceRecords(evidenceRecords));
                this.signatureEvidenceRecordsContainer.setVisible(true);
            } else {
                this.signatureEvidenceRecordsContainer.setVisible(false);
            }
        } else if (token instanceof XmlTimestamp) {
            XmlTimestamp timestamp = (XmlTimestamp)token;
            if (timestamp.getTimestampLevel() != null) {
                this.qualificationLevel.setText(timestamp.getTimestampLevel().getValue().getReadable());
            }
            this.qualificationLevelContainer.setVisible(timestamp.getTimestampLevel() != null);
            this.productionTime.setText(DSSUtils.formatDateToRFC(timestamp.getProductionTime()));
            this.signatureScopes.getChildren().addAll((Collection<Node>)this.getSignatureScope(timestamp.getTimestampScope()));
            this.signatureScopesContainer.setVisible(Utils.isCollectionNotEmpty(timestamp.getTimestampScope()));
        } else if (token instanceof XmlEvidenceRecord) {
            XmlEvidenceRecord evidenceRecord = (XmlEvidenceRecord)token;
            this.qualificationLevelContainer.setVisible(false);
            this.lowestPOE.setText(DSSUtils.formatDateToRFC(evidenceRecord.getPOETime()));
            this.signatureScopes.getChildren().addAll((Collection<Node>)this.getSignatureScope(evidenceRecord.getEvidenceRecordScope()));
            this.signatureScopesContainer.setVisible(Utils.isCollectionNotEmpty(evidenceRecord.getEvidenceRecordScope()));
            XmlTimestamps timestamps = evidenceRecord.getTimestamps();
            if (timestamps != null && Utils.isCollectionNotEmpty(timestamps.getTimestamp())) {
                this.signatureTimestamps.getChildren().addAll((Collection<Node>)this.getSignatureTimestamps(timestamps));
                this.signatureTimestampsContainer.setVisible(true);
            }
        } else {
            throw new UnsupportedOperationException(String.format("XmlToken class '%s' is not supported!", token.getClass().toString()));
        }
        return this.parentNode;
    }

    protected boolean isNotEmpty(XmlDetails xmlDetails) {
        return xmlDetails != null && (Utils.isCollectionNotEmpty(xmlDetails.getError()) || Utils.isCollectionNotEmpty(xmlDetails.getWarning()) || Utils.isCollectionNotEmpty(xmlDetails.getInfo()));
    }

    protected boolean isNotEmpty(XmlCertificateChain xmlCertificateChain) {
        return xmlCertificateChain != null && Utils.isCollectionNotEmpty(xmlCertificateChain.getCertificate());
    }

    protected List<Node> getDetails(XmlDetails xmlDetails) {
        if (this.isNotEmpty(xmlDetails)) {
            ArrayList<Node> messages = new ArrayList<Node>();
            messages.addAll(this.getMessages(xmlDetails.getError(), Color.RED));
            messages.addAll(this.getMessages(xmlDetails.getWarning(), Color.ORANGE));
            messages.addAll(this.getMessages(xmlDetails.getInfo(), Color.BLUE));
            ArrayList<Node> result = new ArrayList<Node>();
            Iterator iterator2 = messages.iterator();
            while (iterator2.hasNext()) {
                result.add((Node)iterator2.next());
                if (!iterator2.hasNext()) continue;
                result.add(new Text(System.lineSeparator()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private List<Node> getMessages(List<XmlMessage> messages, Color color) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (XmlMessage message : messages) {
            Text text = new Text(message.getValue());
            text.setFill(color);
            result.add(text);
        }
        return result;
    }

    protected String getIndicationResultString(XmlToken token) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(token.getIndication().toString());
        if (token.getSubIndication() != null) {
            stringBuilder.append(" - ");
            stringBuilder.append(token.getSubIndication().toString());
        }
        return stringBuilder.toString();
    }

    protected String getIndicationStyle(Indication indication) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-fx-font-weight: bold; ");
        switch (indication) {
            case TOTAL_PASSED: 
            case PASSED: {
                stringBuilder.append("-fx-text-fill: green;");
                break;
            }
            case INDETERMINATE: {
                stringBuilder.append("-fx-text-fill: orange;");
                break;
            }
            case TOTAL_FAILED: 
            case FAILED: {
                stringBuilder.append("-fx-text-fill: red;");
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Indication '%s' is not supported!", indication.name()));
            }
        }
        return stringBuilder.toString();
    }

    protected List<Node> getCertificateChain(XmlCertificateChain xmlCertificateChain) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (xmlCertificateChain != null && Utils.isCollectionNotEmpty(xmlCertificateChain.getCertificate())) {
            for (int i = 0; i < xmlCertificateChain.getCertificate().size(); ++i) {
                XmlCertificate xmlCertificate = xmlCertificateChain.getCertificate().get(i);
                Text text = new Text(xmlCertificate.getQualifiedName());
                result.add(text);
                if (i == 0) {
                    text.setStyle("-fx-font-weight: bold");
                }
                if (!this.isTrustedPath(xmlCertificate, xmlCertificateChain)) {
                    text.setFill(Color.GRAY);
                }
                if (xmlCertificate.isTrusted()) {
                    XmlTrustAnchors trustAnchors = xmlCertificate.getTrustAnchors();
                    if (trustAnchors != null && Utils.isCollectionNotEmpty(trustAnchors.getTrustAnchor())) {
                        for (XmlTrustAnchor xmlTrustAnchor : trustAnchors.getTrustAnchor()) {
                            result.add(this.getIconArrow());
                            result.add(new Text(xmlTrustAnchor.getCountryCode()));
                            result.add(this.getIconArrow());
                            result.add(new Text(xmlTrustAnchor.getTrustServiceProvider()));
                        }
                    } else {
                        result.add(new Text(" (Trust Anchor)"));
                    }
                }
                if (i + 1 == xmlCertificateChain.getCertificate().size()) continue;
                result.add(new Text(System.lineSeparator()));
            }
        } else {
            result.add(new Text("-"));
        }
        return result;
    }

    private Node getIconArrow() {
        Text text = new Text();
        text.setText(" -> ");
        return text;
    }

    private boolean isTrustedPath(XmlCertificate xmlCertificate, XmlCertificateChain xmlCertificateChain) {
        boolean trustAnchorFound = false;
        for (int i = xmlCertificateChain.getCertificate().size() - 1; i > -1; --i) {
            XmlCertificate chainItem = xmlCertificateChain.getCertificate().get(i);
            boolean bl = trustAnchorFound = trustAnchorFound || chainItem.isTrusted();
            if (xmlCertificate != chainItem) continue;
            return trustAnchorFound;
        }
        return trustAnchorFound;
    }

    protected List<Node> getSignatureScope(List<XmlSignatureScope> signatureScopes) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            Iterator<XmlSignatureScope> it = signatureScopes.iterator();
            while (it.hasNext()) {
                XmlSignatureScope signatureScope = it.next();
                Text text = new Text(String.format("%s - %s", new Object[]{signatureScope.getScope(), signatureScope.getValue()}));
                result.add(text);
                if (!it.hasNext()) continue;
                result.add(new Text(System.lineSeparator()));
            }
        } else {
            result.add(new Text("-"));
        }
        return result;
    }

    private List<Node> getSignatureTimestamps(XmlTimestamps xmlTimestamps) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (xmlTimestamps != null && Utils.isCollectionNotEmpty(xmlTimestamps.getTimestamp())) {
            Iterator<XmlTimestamp> it = xmlTimestamps.getTimestamp().iterator();
            while (it.hasNext()) {
                try {
                    XmlTimestamp xmlTimestamp = it.next();
                    Node timestampNode = TokenNodeController.loadController().create(xmlTimestamp);
                    result.add(timestampNode);
                }
                catch (Exception e) {
                    LOG.error(String.format("An error occurred: %s", e.getMessage()), e);
                    throw new ApplicationException(e);
                }
                if (!it.hasNext()) continue;
                result.add(this.getHrNode());
            }
        }
        return result;
    }

    private List<Node> getSignatureEvidenceRecords(XmlEvidenceRecords xmlEvidenceRecords) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (xmlEvidenceRecords != null && Utils.isCollectionNotEmpty(xmlEvidenceRecords.getEvidenceRecord())) {
            Iterator<XmlEvidenceRecord> it = xmlEvidenceRecords.getEvidenceRecord().iterator();
            while (it.hasNext()) {
                try {
                    XmlEvidenceRecord xmlEvidenceRecord = it.next();
                    Node evidenceRecordNode = TokenNodeController.loadController().create(xmlEvidenceRecord);
                    result.add(evidenceRecordNode);
                }
                catch (Exception e) {
                    LOG.error(String.format("An error occurred: %s", e.getMessage()), e);
                    throw new ApplicationException(e);
                }
                if (!it.hasNext()) continue;
                result.add(this.getHrNode());
            }
        }
        return result;
    }

    private Node getHrNode() {
        Region hr = new Region();
        hr.getStyleClass().add("hr");
        return hr;
    }
}

