/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.scope;

import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.spi.validation.scope.EvidenceRecordMasterSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EvidenceRecordScopeFinder
extends AbstractSignatureScopeFinder {
    protected final EvidenceRecord evidenceRecord;

    public EvidenceRecordScopeFinder(EvidenceRecord evidenceRecord) {
        Objects.requireNonNull(evidenceRecord, "EvidenceRecord shall be provided!");
        this.evidenceRecord = evidenceRecord;
    }

    public List<SignatureScope> findEvidenceRecordScope() {
        ArrayList<SignatureScope> evidenceRecordScopes = new ArrayList<SignatureScope>(this.findEvidenceRecordScope(this.evidenceRecord.getReferenceValidation()));
        if (this.isSignatureEmbeddedAndValid(this.evidenceRecord)) {
            this.enrichRecursively(evidenceRecordScopes, this.evidenceRecord.getMasterSignature().getSignatureScopes());
        }
        return evidenceRecordScopes;
    }

    private void enrichRecursively(List<SignatureScope> evidenceRecordScopes, List<SignatureScope> signatureScopes) {
        for (SignatureScope signatureScope : signatureScopes) {
            if (!evidenceRecordScopes.contains(signatureScope)) {
                evidenceRecordScopes.add(signatureScope);
                continue;
            }
            if (!Utils.isCollectionNotEmpty(signatureScope.getChildren())) continue;
            this.enrichRecursively(evidenceRecordScopes, signatureScope.getChildren());
        }
    }

    protected boolean isSignatureEmbeddedAndValid(EvidenceRecord evidenceRecord) {
        if (evidenceRecord.isEmbedded()) {
            for (ReferenceValidation referenceValidation : evidenceRecord.getReferenceValidation()) {
                if (DigestMatcherType.EVIDENCE_RECORD_MASTER_SIGNATURE != referenceValidation.getType() || !referenceValidation.isIntact()) continue;
                return true;
            }
        }
        return false;
    }

    protected List<SignatureScope> findEvidenceRecordScope(List<ReferenceValidation> referenceValidations) {
        ArrayList<SignatureScope> signatureScopes = new ArrayList<SignatureScope>();
        List<DSSDocument> detachedContents = this.evidenceRecord.getDetachedContents();
        ArrayList<DSSDocument> coveredDocuments = new ArrayList<DSSDocument>();
        for (ReferenceValidation referenceValidation : referenceValidations) {
            if (!referenceValidation.isIntact()) continue;
            switch (referenceValidation.getType()) {
                case EVIDENCE_RECORD_ARCHIVE_OBJECT: {
                    DSSDocument detachedDocument = Utils.collectionSize(detachedContents) == 1 ? detachedContents.iterator().next() : this.getDetachedDocument(referenceValidation, detachedContents);
                    if (detachedDocument == null || coveredDocuments.contains(detachedDocument)) break;
                    String fileName = detachedDocument.getName();
                    signatureScopes.add(new FullSignatureScope(fileName, detachedDocument));
                    coveredDocuments.add(detachedDocument);
                    break;
                }
                case EVIDENCE_RECORD_MASTER_SIGNATURE: {
                    AdvancedSignature masterSignature = this.evidenceRecord.getMasterSignature();
                    signatureScopes.add(new EvidenceRecordMasterSignatureScope(masterSignature, this.createDigestDocument(referenceValidation.getDigest())));
                    break;
                }
            }
        }
        return signatureScopes;
    }

    private DSSDocument getDetachedDocument(ReferenceValidation referenceValidation, List<DSSDocument> detachedDocuments) {
        if (Utils.isCollectionNotEmpty(detachedDocuments)) {
            for (DSSDocument document : detachedDocuments) {
                Objects.requireNonNull(document.getName(), "Name shall be defined when multiple documents provided!");
                if (referenceValidation.getDocument() == null || !referenceValidation.getDocument().getName().equals(document.getName())) continue;
                return document;
            }
        }
        return null;
    }
}

