/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.CommonCertificateVerifier;
import eu.europa.esig.dss.spi.validation.TrustAnchorVerifier;

public class CertificateVerifierBuilder {
    private final CertificateVerifier certificateVerifier;

    public CertificateVerifierBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public CertificateVerifier buildCompleteCopy() {
        CommonCertificateVerifier copy = new CommonCertificateVerifier(true);
        if (this.certificateVerifier != null) {
            copy.setAIASource(this.certificateVerifier.getAIASource());
            copy.setCrlSource(this.certificateVerifier.getCrlSource());
            copy.setOcspSource(this.certificateVerifier.getOcspSource());
            copy.setRevocationDataLoadingStrategyFactory(this.certificateVerifier.getRevocationDataLoadingStrategyFactory());
            copy.setRevocationFallback(this.certificateVerifier.isRevocationFallback());
            copy.setRevocationDataVerifier(this.certificateVerifier.getRevocationDataVerifier());
            copy.setTimestampTokenVerifier(this.certificateVerifier.getTimestampTokenVerifier());
            copy.setTrustAnchorVerifier(this.certificateVerifier.getTrustAnchorVerifier());
            copy.setCheckRevocationForUntrustedChains(this.certificateVerifier.isCheckRevocationForUntrustedChains());
            copy.setAdjunctCertSources(this.certificateVerifier.getAdjunctCertSources());
            copy.setTrustedCertSources(this.certificateVerifier.getTrustedCertSources());
            copy.setAlertOnInvalidSignature(this.certificateVerifier.getAlertOnInvalidSignature());
            copy.setAlertOnInvalidTimestamp(this.certificateVerifier.getAlertOnInvalidTimestamp());
            copy.setAlertOnMissingRevocationData(this.certificateVerifier.getAlertOnMissingRevocationData());
            copy.setAlertOnNoRevocationAfterBestSignatureTime(this.certificateVerifier.getAlertOnNoRevocationAfterBestSignatureTime());
            copy.setAlertOnRevokedCertificate(this.certificateVerifier.getAlertOnRevokedCertificate());
            copy.setAlertOnUncoveredPOE(this.certificateVerifier.getAlertOnUncoveredPOE());
            copy.setAlertOnExpiredCertificate(this.certificateVerifier.getAlertOnExpiredCertificate());
            copy.setAlertOnNotYetValidCertificate(this.certificateVerifier.getAlertOnNotYetValidCertificate());
            copy.setAugmentationAlertOnSignatureWithoutCertificates(this.certificateVerifier.getAugmentationAlertOnSignatureWithoutCertificates());
            copy.setAugmentationAlertOnHigherSignatureLevel(this.certificateVerifier.getAugmentationAlertOnHigherSignatureLevel());
            copy.setAugmentationAlertOnSelfSignedCertificateChains(this.certificateVerifier.getAugmentationAlertOnSelfSignedCertificateChains());
        }
        return copy;
    }

    public CertificateVerifier buildOfflineCopy() {
        CommonCertificateVerifier offlineCertificateVerifier = new CommonCertificateVerifier(true);
        if (this.certificateVerifier != null) {
            offlineCertificateVerifier.setAdjunctCertSources(this.certificateVerifier.getAdjunctCertSources());
            offlineCertificateVerifier.setTrustedCertSources(this.certificateVerifier.getTrustedCertSources());
            offlineCertificateVerifier.setRevocationDataVerifier(this.certificateVerifier.getRevocationDataVerifier());
            offlineCertificateVerifier.setTimestampTokenVerifier(this.certificateVerifier.getTimestampTokenVerifier());
            offlineCertificateVerifier.setTrustAnchorVerifier(this.getTrustAnchorVerifierOfflineCopy(this.certificateVerifier.getTrustAnchorVerifier()));
            offlineCertificateVerifier.setAlertOnInvalidSignature(this.certificateVerifier.getAlertOnInvalidSignature());
            offlineCertificateVerifier.setAlertOnInvalidTimestamp(this.certificateVerifier.getAlertOnInvalidTimestamp());
            offlineCertificateVerifier.setAlertOnMissingRevocationData(this.certificateVerifier.getAlertOnMissingRevocationData());
            offlineCertificateVerifier.setAlertOnNoRevocationAfterBestSignatureTime(this.certificateVerifier.getAlertOnNoRevocationAfterBestSignatureTime());
            offlineCertificateVerifier.setAlertOnRevokedCertificate(this.certificateVerifier.getAlertOnRevokedCertificate());
            offlineCertificateVerifier.setAlertOnUncoveredPOE(this.certificateVerifier.getAlertOnUncoveredPOE());
            offlineCertificateVerifier.setAlertOnExpiredCertificate(this.certificateVerifier.getAlertOnExpiredCertificate());
            offlineCertificateVerifier.setAlertOnNotYetValidCertificate(this.certificateVerifier.getAlertOnNotYetValidCertificate());
            offlineCertificateVerifier.setAugmentationAlertOnSignatureWithoutCertificates(this.certificateVerifier.getAugmentationAlertOnSignatureWithoutCertificates());
            offlineCertificateVerifier.setAugmentationAlertOnHigherSignatureLevel(this.certificateVerifier.getAugmentationAlertOnHigherSignatureLevel());
            offlineCertificateVerifier.setAugmentationAlertOnSelfSignedCertificateChains(this.certificateVerifier.getAugmentationAlertOnSelfSignedCertificateChains());
        }
        return offlineCertificateVerifier;
    }

    public CertificateVerifier buildOfflineAndSilentCopy() {
        CommonCertificateVerifier offlineCertificateVerifier = new CommonCertificateVerifier(true);
        if (this.certificateVerifier != null) {
            offlineCertificateVerifier.setAdjunctCertSources(this.certificateVerifier.getAdjunctCertSources());
            offlineCertificateVerifier.setTrustedCertSources(this.certificateVerifier.getTrustedCertSources());
            offlineCertificateVerifier.setRevocationDataVerifier(this.certificateVerifier.getRevocationDataVerifier());
            offlineCertificateVerifier.setTimestampTokenVerifier(this.certificateVerifier.getTimestampTokenVerifier());
            offlineCertificateVerifier.setTrustAnchorVerifier(this.getTrustAnchorVerifierOfflineCopy(this.certificateVerifier.getTrustAnchorVerifier()));
        }
        offlineCertificateVerifier.setAlertOnInvalidSignature(null);
        offlineCertificateVerifier.setAlertOnInvalidTimestamp(null);
        offlineCertificateVerifier.setAlertOnMissingRevocationData(null);
        offlineCertificateVerifier.setAlertOnNoRevocationAfterBestSignatureTime(null);
        offlineCertificateVerifier.setAlertOnRevokedCertificate(null);
        offlineCertificateVerifier.setAlertOnUncoveredPOE(null);
        offlineCertificateVerifier.setAlertOnExpiredCertificate(null);
        offlineCertificateVerifier.setAlertOnNotYetValidCertificate(null);
        offlineCertificateVerifier.setAugmentationAlertOnSignatureWithoutCertificates(null);
        offlineCertificateVerifier.setAugmentationAlertOnHigherSignatureLevel(null);
        offlineCertificateVerifier.setAugmentationAlertOnSelfSignedCertificateChains(null);
        return offlineCertificateVerifier;
    }

    private TrustAnchorVerifier getTrustAnchorVerifierOfflineCopy(TrustAnchorVerifier originalTrustAnchorVerifier) {
        TrustAnchorVerifier trustAnchorVerifier = TrustAnchorVerifier.createEmptyTrustAnchorVerifier();
        trustAnchorVerifier.setUseSunsetDate(false);
        if (originalTrustAnchorVerifier != null) {
            trustAnchorVerifier.setTrustedCertificateSource(originalTrustAnchorVerifier.getTrustedCertificateSource());
            trustAnchorVerifier.setAcceptRevocationUntrustedCertificateChains(originalTrustAnchorVerifier.isAcceptRevocationUntrustedCertificateChains());
            trustAnchorVerifier.setAcceptTimestampUntrustedCertificateChains(originalTrustAnchorVerifier.isAcceptTimestampUntrustedCertificateChains());
        }
        return trustAnchorVerifier;
    }

    public CertificateVerifier buildCompleteCopyForValidation() {
        CertificateVerifier copy = this.buildCompleteCopy();
        copy.setRevocationFallback(true);
        return copy;
    }
}

