/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSSSecurityProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DSSSecurityProvider.class);
    private static Provider securityProvider;
    private static Provider[] alternativeSecurityProviders;

    private DSSSecurityProvider() {
    }

    public static Provider getSecurityProvider() {
        if (securityProvider == null) {
            securityProvider = new BouncyCastleProvider();
            LOG.debug("DSSSecurityProvider initialized with {}", (Object)BouncyCastleProvider.class);
        }
        return securityProvider;
    }

    public static String getSecurityProviderName() {
        return DSSSecurityProvider.getSecurityProvider().getName();
    }

    public static void setSecurityProvider(Provider provider) {
        DSSSecurityProvider.assertProvidersNotNull(provider);
        securityProvider = provider;
        LOG.debug("DSSSecurityProvider initialized with {}", (Object)provider.getClass());
    }

    public static void setSecurityProvider(String providerName) throws SecurityException {
        DSSSecurityProvider.assertProviderNamesNotNull(providerName);
        securityProvider = DSSSecurityProvider.getProvider(providerName);
        LOG.debug("DSSSecurityProvider initialized with {}", (Object)providerName);
    }

    public static Provider[] getAlternativeSecurityProviders() {
        if (alternativeSecurityProviders == null) {
            alternativeSecurityProviders = new Provider[0];
        }
        return alternativeSecurityProviders;
    }

    public static String[] getAlternativeSecurityProviderNames() {
        if (alternativeSecurityProviders == null || alternativeSecurityProviders.length == 0) {
            return new String[0];
        }
        String[] providerNames = new String[alternativeSecurityProviders.length];
        for (int i = 0; i < alternativeSecurityProviders.length; ++i) {
            providerNames[i] = alternativeSecurityProviders[i].getName();
        }
        return providerNames;
    }

    public static void setAlternativeSecurityProviders(Provider ... alternativeSecurityProviders) {
        DSSSecurityProvider.assertProvidersNotNull(alternativeSecurityProviders);
        DSSSecurityProvider.alternativeSecurityProviders = alternativeSecurityProviders;
    }

    public static void setAlternativeSecurityProviders(String ... alternativeSecurityProviderNames) throws SecurityException {
        DSSSecurityProvider.assertProviderNamesNotNull(alternativeSecurityProviderNames);
        if (alternativeSecurityProviderNames == null || alternativeSecurityProviderNames.length == 0) {
            return;
        }
        Provider[] providerArray = new Provider[alternativeSecurityProviderNames.length];
        for (int i = 0; i < providerArray.length; ++i) {
            providerArray[i] = DSSSecurityProvider.getProvider(alternativeSecurityProviderNames[i]);
        }
        alternativeSecurityProviders = providerArray;
    }

    private static void assertProvidersNotNull(Provider ... providers) {
        Objects.requireNonNull(providers, "Array of providers cannot be null!");
        for (Provider provider : providers) {
            Objects.requireNonNull(provider, "Provider cannot be null!");
        }
    }

    private static void assertProviderNamesNotNull(String ... providerNames) {
        Objects.requireNonNull(providerNames, "Array of provider names cannot be null!");
        for (String providerName : providerNames) {
            Objects.requireNonNull(providerName, "Provider name cannot be null!");
        }
    }

    private static Provider getProvider(String providerName) throws SecurityException {
        try {
            Provider provider = Security.getProvider(providerName);
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Unable to instantiate security Provider for name '%s'! The implementation is not found.", providerName));
            }
            return provider;
        }
        catch (Exception e) {
            throw new SecurityException(String.format("An error occurred on security Provider initialization : %s", e.getMessage()), e);
        }
    }

    public static void initSystemProviders() {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
        Provider[] securityProviders = DSSSecurityProvider.getAlternativeSecurityProviders();
        if (securityProviders != null && securityProviders.length != 0) {
            for (Provider provider : securityProviders) {
                Security.addProvider(provider);
            }
        }
    }
}

