/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service;

import eu.europa.esig.dss.service.NonceSource;
import java.security.SecureRandom;

public class SecureRandomNonceSource
implements NonceSource {
    private static final long serialVersionUID = 8999041563539837258L;
    private final SecureRandom secureRandom = new SecureRandom();
    private final int nonceSize;

    public SecureRandomNonceSource() {
        this(32);
    }

    public SecureRandomNonceSource(int nonceSize) {
        if (nonceSize < 1) {
            throw new IllegalArgumentException("The nonce size cannot be 0 or smaller!");
        }
        this.nonceSize = nonceSize;
    }

    @Override
    public byte[] getNonceValue() {
        byte[] bytes = new byte[this.nonceSize];
        this.secureRandom.nextBytes(bytes);
        return bytes;
    }
}

